
/**
 * 选择文件
 */
function changeFaceFile(fileObj){
    var file = fileObj.files['0'];
    //图片方向角 added by lzk
    var Orientation = null;
    var ImageWidth = 0;
    var ImageHeight = 0;

    if (file) {
        var rFilter = /^(image\/jpg|image\/jpeg|image\/png)$/i; // 检查图片格式
        if (!rFilter.test(file.type)) {
            $('#tips_msg').text('图片格式支持jpg和png。');
            showTips('orther_tips',false);
            return;
        }
        uploadStart();
        //获取照片方向角属性，用户旋转控制
        EXIF.getData(file, function() {
            EXIF.getAllTags(this);
            Orientation = EXIF.getTag(this, 'Orientation');

            var oReader = new FileReader();
            oReader.readAsDataURL(file);
            oReader.onload = function(e) {
                var image = new Image();
                image.src = e.target.result;
                image.onload = function() {
                    // 原图大小
                    ImageWidth = this.naturalWidth;
                    ImageHeight = this.naturalHeight;
                    // 压缩裁剪的大小
                    var expectWidth = ImageWidth;
                    var expectHeight = ImageHeight;
                    if (expectWidth > 1080) {
                        expectHeight = 1080 * expectHeight / expectWidth;
                        expectWidth = 1080;
                    }
                    if (expectHeight > 1920) {
                        expectWidth = 1920 * expectWidth / expectHeight;
                        expectHeight = 1920;
                    }
                    // 确保图片宽度是4的倍数 图片高度是2的倍数 避免提取人脸特征（90127）需要
                    expectWidth = expectWidth - expectWidth % 4;
                    expectHeight = expectHeight - expectHeight % 2;

                    var canvas = document.createElement("canvas");
                    canvas.width = expectWidth;
                    canvas.height = expectHeight;
                    var ctx = canvas.getContext("2d");
                    //清空画布
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                    // 压缩图片
                    ctx.drawImage(this, 0, 0, expectWidth, expectHeight);
                    var base64 = null;
                    // 选择图片
                    if (navigator.userAgent.match(/iphone/i)) {
                        //修复ios
                        console.log('iphone');
                        var neetRotateImg = true;
                        var iOSVerInfo = iOSVersion();
                        if(iOSVerInfo){
                            if(iOSVerInfo[0] >= 13){
                                if(iOSVerInfo[0] == 13){
                                    if(iOSVerInfo[1] >= 2){
                                        neetRotateImg = false;
                                    }
                                }else{
                                    neetRotateImg = false;
                                }
                            }
                        }
                        if(neetRotateImg){
                            //如果方向角不为1，都需要进行旋转 added by lzk
                            if(Orientation && Orientation != "" && Orientation != 1){
                                switch(Orientation){
                                    case 6:     // 旋转90度
                                        ctx.rotate(Math.PI / 2);
                                        ctx.drawImage(this, 0, -expectWidth, expectHeight, expectWidth);
                                        break;
                                    case 3:// 旋转180度
                                        ctx.rotate(Math.PI);
                                        ctx.drawImage(this, -expectWidth, -expectHeight, expectWidth, expectHeight);
                                        break;
                                    case 8:     // 旋转-90度
                                        ctx.rotate(3 * Math.PI / 2);
                                        ctx.drawImage(this, -expectHeight, 0, expectHeight, expectWidth);
                                        break;
                                }
                            }
                        }
                        base64 = canvas.toDataURL("image/jpeg", 0.8);
                    }else if (navigator.userAgent.match(/Android/i)) {
                        // 修复android
                        console.log('android');
                        var encoder = new JPEGEncoder();
                        base64 = encoder.encode(ctx.getImageData(0, 0, expectWidth, expectHeight), 80);
                    }else{
                        console.log('其他设备');
                        if(Orientation && Orientation != "" && Orientation != 1){
                            switch(Orientation){
                                case 6:     // 旋转90度
                                    ctx.rotate(Math.PI / 2);
                                    ctx.drawImage(this, 0, -expectWidth, expectHeight, expectWidth);
                                    break;
                                case 3:// 旋转180度
                                    ctx.rotate(Math.PI);
                                    ctx.drawImage(this, -expectWidth, -expectHeight, expectWidth, expectHeight);
                                    break;
                                case 8:     // 旋转-90度
                                    ctx.rotate(3 * Math.PI / 2);
                                    ctx.drawImage(this, -expectHeight, 0, expectHeight, expectWidth);
                                    break;
                            }
                        }

                        base64 = canvas.toDataURL("image/jpeg", 0.8);
                    }

                    uploadFaceImg(base64);
                };
            };
        });
    }
}

function iOSVersion() {
    var ua = navigator.userAgent.toLowerCase();
    var ver = null;
    if(ua.indexOf("like mac os x") > 0){
        var reg = /os [\d._]*/gi ;
        var verinfo = ua.match(reg) ;
        var version = (verinfo+"").replace(/[^0-9|_.]/ig,"").replace(/_/ig,".");
        ver = version.split(".");
    }
    console.log("ver:"+ver);
    return ver;
}

/**
 * 上传人脸图片
 */
function uploadFaceImg(imgBase64) {
    $('.faceImage').attr('src',imgBase64); //显示预览图片
    var uploadData={};
    uploadData.userId=$("#hiddenUserId").val();
    uploadData.imgBase64=imgBase64;
    doPost(ctx+"/info/uploadFaceImage",uploadData,false,function(result){
        if(typeof result == "string"){
            if(result == ""){
                $('#tips_msg').text('上传失败，请稍后重试');
                showTips('orther_tips',false);
                uploadEnd();
                return;
            }
            result = eval('('+result+')');
        }
        uploadEnd();
        if(result.error == 0){//绑定成功
            $('#ok_msg').text('上传成功');
            showTips('success_tips',true);
        }else{//其他提示 如校验错误
            $('#tips_msg').text(result.errormsg);
            showTips('orther_tips',false);
        }

    },function (error) {
        $('#tips_msg').text('上传失败。');
        showTips('orther_tips',false);
        uploadEnd();
    });

}


/**
 * 上传中阻止重复上传
 */
function uploadStart() {
    $("#upload_tip").show();
    $("#changeFaceBtn").addClass("div-disable");
    $("#faceBackBtn").addClass("div-disable");

}

/**
 * 上传结束
 */
function uploadEnd() {
    $("#upload_tip").hide();
    $("#changeFaceBtn").removeClass("div-disable");
    $("#faceBackBtn").removeClass("div-disable");
}

/**
 * 初始化人脸图片
 */
function initFaceImg() {
    var hiddenFaceUrl=$("#hiddenFaceUrl").val();
    if(hiddenFaceUrl!=""){
        $('.faceImage').attr('src',hiddenFaceUrl);
    }
}