/**
 * 身份证阅读器-v2版本
 * Created by 草原狼 on 2018/1/31.
 */
!(function(win) {
    /**
     * 定义构造函数
     *
     * @param config = {"host":"读卡器端口"}
     */
    function IDCard(config) {
        this.host = config.host;
        this.sendFlag = 0;
    }

    function IDCard(config) {
        this.host = config.host;
        this.sendFlag = 0;
    }
    /**
     * 获取可显示的base64
     */
    IDCard.prototype.getViewBase64 = function(base64){
        return "data:image/jpeg;base64," + base64;
    }
    /**
     * 清理数据
     */
    IDCard.prototype.clearText = function(){
        /*
        document.getElementById("text_ID").value = "";
        document.getElementById("text_name").value = "";
        document.getElementById("text_sex").value = "";
        document.getElementById("text_nation").value = "";
        document.getElementById("text_birthday").value = "";
        document.getElementById("text_address").value = "";
        document.getElementById("text_idNum").value = "";
        document.getElementById("text_dept").value = "";
        document.getElementById("text_effDate").value = "";
        document.getElementById("text_expDate").value = "";
        document.getElementById("text_result").value = "";
        document.getElementById("PhotoID").src = "";
        */
    }

    IDCard.prototype.openReader = function() {
        var result = {};
        var that = this;
        //debugger;
        var host = "ws://127.0.0.1:6688";
        if(that.socket == null){
            that.resultMsg("设备连接成功.");
            that.socket = new WebSocket(host);
        }else{
            that.resultMsg("设备已开打.");
        }

        try {
            that.socket.onopen = function (msg) {
                that.clearZP(); //清除zp文件夹的身份证头像
            };
            that.socket.onerror = function(){
                $("#hx_message").val(false);
                // alert("请安装驱动");
                // alert("设备已断开，请刷新页面继续使用,并且确保已经安装驱动.");
                /*
                that.closeReader();
                that.closeSocket();
                that.openReader();
                */
            };
            that.socket.onmessage = function (msg) {
                //debugger;
                if (typeof msg.data == "string") {
                    var msgM=msg.data+"";
                    if(that.sendFlag==1){
                        //resultMsg("清除头像成功.");
                        that.openReaderStart();
                    }else if(that.sendFlag==2){
                        if(msgM[0]=="1"){  //1:连接设备成功
                            that.resultMsg("连接成功.");
                        }else{ //2:连接设备失败
                            that.resultMsg("请连接设备.");
                        }
                    }else if(that.sendFlag==3){
                        if(msgM[0] == "0"){
                            that.resultMsg("身份证阅读器异常,请联系管理员.");
                        }else if(msgM[0]=="3"){
                            alert("请连接设备.");
                            that.resultMsg("请连接设备.");
                        }else if(msgM[0]=="4"){
                            that.resultMsg("请放身份证.");
                        }else if(msgM[0]=="5"){
                            that.resultMsg("读取身份证信息失败,请查身份证是否有效.");
                        }else if(msgM[0]=="6"){
                            that.resultMsg("读取身份证头像失败,请查身份证是否有效.");
                        }else{
                            //获得身份信息
                            result.chipIDNum = msgM.match(/identityCardID(\S*)identityCardID/)[1];  //证件ID
                            result.name = msgM.match(/name(\S*)name/)[1];   //姓名
                            result.sex = msgM.match(/sex(\S*)sex/)[1];   //性别
                            result.nation = msgM.match(/nation(\S*)nation/)[1];     //民族
                            result.birthday = msgM.match(/birthDate(\S*)birthDate/)[1];       //出生日期
                            result.address = msgM.match(/address(\S*)address/)[1];          //地址
                            result.idNum = msgM.match(/IDCode(\S*)IDCode/)[1];         //身份证号
                            result.dept = msgM.match(/issuingAuthority(\S*)issuingAuthority/)[1];  //签发机关
                            result.effDate = msgM.match(/beginPeriodOfValidity(\S*)beginPeriodOfValidity/)[1];       //有效日期起始
                            result.expDate = msgM.match(/endPeriodOfValidity(\S*)endPeriodOfValidity/)[1];        //有效日期截止
                            result.base64Photo = msgM.match(/##(\S*)##/)[1];//显示头像
                            /*
                             document.all("PhotoZW").src = "data:image/jpeg;base64,"+msgM.match(/#zw#(\S*)#zw#/)[1];//显示指纹
                             */
                            if(result.expDate == '长期'){
                                result.expDate = 0;
                            }
                            //回调结果
                            that.readResult(result);
                            //console.log(result);
                        }
                    }else if(that.sendFlag==4){
                        that.closeSocket();
                        if(msgM[0] == "1"){  //1:关闭设备成功
                            that.resultMsg("关闭设备成功.");
                        }
                    }
                }
                else{
                    alert("连接异常,请检查是否成功安装驱动.");
                }
            };
        }
        catch (ex) {
            alert("连接异常,请检查是否成功安装驱动.");
        }
    }
    IDCard.prototype.resultMsg = function(msg) {
        //document.getElementById("text_result").value += "\r\n" + msg;
        console.log(msg)
    }
    //清除BMP图片
    IDCard.prototype.clearZP = function(){
        this.sendFlag=1;
        this.socket.send("SDT_ClearZP##");
    }
    //连接设备
    IDCard.prototype.openReaderStart = function(){
        this.sendFlag=2;
        this.socket.send("SDT_OpenReader#");
    }
    //读取身份信息
    IDCard.prototype.readIDCard = function() {
        this.sendFlag=3;
        try {
            this.socket.send("SDT_ReadCard##");
        }
        catch (ex) {
            this.resultMsg("请打开设备.");
            this.openReader();
        }
    }
    //关闭设备
    IDCard.prototype.closeReader = function() {
        this.sendFlag=4;
        try {
            this.socket.send("SDT_CloseReader#");
        }
        catch (ex) {
            this.resultMsg("请打开设备.");
        }
    }
    IDCard.prototype.closeSocket = function() {
        try {
            if(this.socket != null){
                this.socket.close();
                this.socket = null;
            }
        }
        catch (ex) {
        }
    };

    /**
     * 初始化插件
     */
    IDCard.prototype.init = function(){
        //打开设备
        this.openReader();
    }

    var config = {
        "host" : "ws://127.0.0.1:6688"
    }
    // IDCard对象绑定到window对象
    win.IDCard = new IDCard(config);
    return  win.IDCard;

})(window);