/**
 * 定义身份证读卡模块
 * 使用方法见readme.md
 * @param win
 */
!(function(win) {

	/**
	 * 定义构造函数
	 *
	 * @param config =
	 *            {"cardReader":"读卡器对象","host":"监听地址和端口","path":"头像保存路径","bmp":"bmp格式文件名","jpg":"jpg格式文件名"}
	 */
	function IDCard(config) {
		this.host = config.host;
		this.socket = null;
		this.sendFlag = 0;
	}



	IDCard.prototype.clearText = function(){
		console.log("清理数据");
	}

	IDCard.prototype.openReader = function(){
		var that = this;
		var result = {};
		if(this.socket == null){
			this.resultMsg("设备连接成功.");
			this.socket = new WebSocket(this.host);
		}else{
			this.resultMsg("设备已开打.");
		}
		try {
			this.socket.onopen = function (msg) {
				//清除zp文件夹的身份证头像
				that.clearZP();
				setTimeout(that.readIDCard(),5000)
			};
			this.socket.onerror = function(){
                $("#hx_message").val(false);
				// alert("请安装驱动.");
			};
			this.socket.onmessage = function (msg) {
				if (typeof msg.data == "string") {
					var msgM=msg.data+"";
					if(that.sendFlag == 1){
						//resultMsg("清除头像成功.");
						that.openReaderStart();
					}else if(that.sendFlag==2){
						if(msgM[0]=="1"){  //1:连接设备成功
							that.resultMsg("连接成功.");
						}else{ //2:连接设备失败
							that.resultMsg("请连接设备.");
						}
					}else if(that.sendFlag==3){
						if(msgM[0] == "0"){
							that.resultMsg("身份证阅读器异常,请联系管理员.");
							that.operable(true);
						}else if(msgM[0]=="3"){
							that.resultMsg("请连接设备.");
							that.operable(true);
						}else if(msgM[0]=="4"){
							that.resultMsg("请放身份证.");
							that.operable(true);
						}else if(msgM[0]=="5"){
							that.resultMsg("读取身份证信息失败,请查身份证是否有效.");
							that.operable(true);
						}else if(msgM[0]=="6"){
							that.resultMsg("读取身份证头像失败,请查身份证是否有效.");
							that.operable(true);
						}else{
							console.log(msgM[1]);
							//获得身份信息
							result.chipIDNum = msgM.match(/identityCardID(\S*)identityCardID/)[1];
							// 姓名
							result.name = msgM.match(/name(\S*)name/)[1];
							// 性别
							result.sex = msgM.match(/sex(\S*)sex/)[1];
							// 民族
							result.nation = msgM.match(/nation(\S*)nation/)[1];
							// 出生日期
							result.birthday = msgM.match(/birthDate(\S*)birthDate/)[1];
							// 地址
							result.address = msgM.match(/address(\S*)address/)[1];
							// 身份证号
							result.idNum = msgM.match(/IDCode(\S*)IDCode/)[1];
							// 签发机关
							result.dept = msgM.match(/issuingAuthority(\S*)issuingAuthority/)[1];
							// 有效日期起始
							result.effDate = msgM.match(/beginPeriodOfValidity(\S*)beginPeriodOfValidity/)[1];
							// 有效日期截止
							result.expDate = msgM.match(/endPeriodOfValidity(\S*)endPeriodOfValidity/)[1];
							// base64编码头像(不带'data:image/png;base64,'前缀)
							result.base64Photo= msgM.match(/##(\S*)##/)[1];
							//console.log(result);
							//回调结果
							that.readResult(result);
						}
					}else if(that.sendFlag==4){
						that.closeSocket();
						if(msgM[0] == "1"){  //1:关闭设备成功
							that.resultMsg("关闭设备成功.");
						}
					}
				}
				else{
					alert("连接异常,请检查是否成功安装华旭J15S驱动.");
				}
			};
		}
		catch (ex) {
			alert("连接异常,请检查是否成功安装华旭J15S驱动.");
		}
	}

	IDCard.prototype.resultMsg = function(msg){
		//document.getElementById("text_result").value += "\r\n" + msg;
		console.log(msg);
	}
	//清除BMP图片
	IDCard.prototype.clearZP = function(){
		this.sendFlag = 1;
		this.socket.send("SDT_ClearZP#");
	}
	//连接设备
	IDCard.prototype.openReaderStart = function(){
		this.sendFlag = 2;
		this.socket.send("SDT_OpenReader#");
	}
	//读取身份信息
	IDCard.prototype.readIDCard = function() {
		this.sendFlag = 3;
		try {
			this.socket.send("SDT_ReadCard#");
		}
		catch (ex) {
			this.resultMsg("请打开设备."+ex);
		}
	}
	//关闭设备
	IDCard.prototype.closeReader = function(){
		this.sendFlag = 4;
		try {
			this.socket.send("SDT_CloseReader#");
		}
		catch (ex) {
			this.resultMsg("请打开设备.");
		}
	}
	IDCard.prototype.closeSocket = function(){
		try {
			if(this.socket != null){
				this.socket.close();
				this.socket = null;
			}
		}
		catch (ex) {
		}
	};

	/**
	 * 获取可显示的base64
	 */
	IDCard.prototype.getViewBase64 = function(base64){
		return "data:image/jpeg;base64," + base64;
	}
	/**
	 * 初始化插件
	 */
	IDCard.prototype.init = function(){
		var objX = document.getElementById('objActiveX-hxgc-device');
		if(objX != null && objX.type == 'application/hxgc-device.j10'){
			this.cardReader = objX;
		}else{
			var objectX = document.createElement("object");
			objectX.id = 'objActiveX-hxgc-device';
			objectX.type = "application/hxgc-device.j10"
			objectX.width = 0;
			objectX.height = 0;
			var body = document.body;
			body.appendChild(objectX);
			//this.cardReader = document.getElementById('objActiveX111');
			this.cardReader = objectX;
		}
		//打开设备
		this.openReader();
	}


	var config = {
		"host" : "ws://127.0.0.1:6688"
	}
	// IDCard对象绑定到window对象
	return win.IDCard = new IDCard(config);

})(window);