/**
 * 
 * 构造方法
 * 该文件依赖七牛
 * @returns
 */
function FileObject(config){
	var QiniuX = new QiniuJsSDK();
	QiniuX.uploader(option);
}

FileObject.prototype.getOption = function(config){
	var option = {
			runtimes: 'html5,flash,html4',      // 上传模式,依次退化
			browse_button: 'chooseYFile',         // 上传选择的点选按钮，**必需**
		    unique_names: false,              // 默认 false，key 为文件名。若开启该选项，JS-SDK 会为每个文件自动生成key（文件名）
		    save_key: false,                  // 默认 false。若在服务端生成 uptoken 的上传策略中指定了 `sava_key`，则开启，SDK在前端将不对key进行任何处理
		    domain: 'http://picture.zzwtec.com/',     // bucket 域名，下载资源时用到，**必需**
		    uptoken_func: function(file){    // 在需要获取 uptoken 时，该方法会被调用 传入文件名获取token
		    	if(file.name.indexOf("&")>0 ||file.name.indexOf("'")>0||file.name.indexOf("\"")>0){
		    		alert("文件名中不能含有“&”、“'”、“\"”等特殊符号。");
	        	}else{
			    	var ajax = new XMLHttpRequest();
			    	var hiddenCommunityId=$("#hiddenCommunityId").val();
			    	ajax.open('POST', ctx+'/sys/community/getHomePageFileToken', false);
			    	ajax.setRequestHeader("If-Modified-Since", "0");
			    	ajax.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			    	ajax.send('fileName='+file.name+'&communityId='+hiddenCommunityId+'&xory=y');
			    	if (ajax.status === 200) {
			    		if(isOK(ajax.responseText)){
				    		var res = JSON.parse(ajax.responseText);
				    		console.log('from server uptoken:'+res.uptoken);
				    		file['filekey'] = res.filekey;
				    		$("#hiddenYfileStoreId").val(res.fileStoreId)
				    		return res.uptoken;
			    		}
			    		return '';
			    	} else {
			    		l.log('custom uptoken_func err');
			    		return '';
			    	}
            	}
			},
			// 设置上传文件的时候是否每次都重新获取新的 uptoken
			get_new_uptoken: true, 
			insertOnly:0,
			// 上传区域 DOM ID，默认是 browser_button 的父元素，
		    container: 'containerY',    
		    // 最大文件体积限制
		    max_file_size: '100mb',  
		    filters : [
		   			{title : "Image files", extensions : "jpg,png"}
		   	],//  这个数组是选择器，就是上传文件时限制的上传文件类型
			flash_swf_url : ctx+'/static/libs/plupload-2.1.8/js/Moxie.swf', //引入 flash,相对路径
			silverlight_xap_url : ctx+'/static/libs/plupload-2.1.8/js/Moxie.xap',
			multi_selection: false,             //设置单文件上传
		    max_retries: 1,                     // 上传失败最大重试次数
		    dragdrop: true,                     // 开启可拖曳上传
		    drop_element: 'containerY',          // 拖曳上传区域元素的 ID，拖曳文件或文件夹后可触发上传
		    chunk_size: '4mb',                  // 分块上传时，每块的体积
		    auto_start: true,                  // 选择文件后自动上传，若关闭需要自己绑定事件触发上传,
			init: {
		        'FilesAdded': function(up, files) {//队列中只能有一个文件
		        	
		            plupload.each(files, function(file) {

		            	// 如果上传文件大于1 ps：第一个文件上传的时候用户选择第二个文件  
	                    // 这时队列大于1，队列的第一个文件是正在上传的，第二个是新选的  
	                    if (up.files.length > 1) {  
	                        // 移除当前队列里第一个文件  
	                        up.removeFile(up.files[0]);  
	                    }
		            	
		            });
		            
		            //标记有文件正在上传  不允许提交表单或关闭编辑窗口
		        	isUploadingY=true;
		        },
		        'BeforeUpload': function(up, file) {
		            // 每个文件上传前,处理相关的事情
		        	
		        },
		        'UploadProgress': function(up, file) {
		             // 每个文件上传时,处理相关的事情		        	
		        	 $('#imgYspan').html(file.percent + '%');
		        },
		        'FileUploaded': function(up, file, info) {
			         console.log('up:'+JSON.stringify(up));
		             console.log('file:'+JSON.stringify(file));
		             console.log('info:'+JSON.stringify(info));	            	
		             var domain = up.getOption('domain');
		             //生成时间戳随机数用于放在链接后面 避免总是看到图片缓存
		             var randnum=new Date().getTime()+parseInt(Math.random()*100);
		             var qnurl=domain+file.filekey;	  
		             var showurl=qnurl+"?t="+randnum;
		             $(':input[type=hidden][name=imgY]').val(showurl);
		             console.log('qnurl:'+qnurl);		                
				     //标记文件上传完毕 允许提交表单或关闭编辑窗口
		        	 isUploadingY=false;		        	 
		        	 //等待2秒
		        	 setTimeout(function(){
		        		 //预览图
		                 var imghtml="<a   href='"+showurl+"' target='_blank'><img src='"+showurl+"&imageView2/2/h/25' style='margin : 0px 20px; '/></a>";
		                 $("#imgYspan").html(imghtml);
		        	},2000);                    
	                    
		        },
		        'Error': function(up, err, errTip) {
		        	//上传出错时,处理相关的事情
		        	console.log('up:'+JSON.stringify(up));
	            	console.log('err:'+JSON.stringify(err));
	            	console.log('errTip:'+JSON.stringify(errTip));
	            	alert(errTip);
		               
		        },
		        'UploadComplete': function(up, files) {
		            //队列文件处理完毕后,处理相关的事情
		        },
		        'Key': function(up, file) {
		            // 若想在前端对每个文件的key进行个性化处理，可以配置该函数
		            // 该配置必须要在 unique_names: false , save_key: false 时才生效
		            var key = file.filekey;
		            // do something with key here
		            return key;
		        }
		    }
		};
	return option;
}