/* 
 * 拖动滑块
 */
(function($){
    $.fn.drag = function(options){
        var x, drag = this, isMove = false, defaults = {};
        $.fn.drag.prototype = {st:0,et:0};
    	
        var options = $.extend(defaults, options);
        //添加背景，文字，滑块
        var html = '<div class="drag_bg"></div>'+
                    '<div class="drag_text" onselectstart="return false;" unselectable="on">拖动滑块验证</div>'+
                    '<div class="handler text-center"><span class="glyphicon glyphicon-forward"></div>';
        this.append(html);
        
        var handler = drag.find('.handler');
        var drag_bg = drag.find('.drag_bg');
        var text = drag.find('.drag_text');
        var maxWidth = drag.width() - handler.width();  //能滑动的最大间距
        
        handler.attr("id","dragHandlerId");
        
        //鼠标按下时候的x轴的位置
        handler.mousedown(dragDownFun);
        
        //鼠标指针在上下文移动时，移动距离大于0小于最大间距，滑块x轴位置等于鼠标移动距离
        $(document).mousemove(dragMoveFun).mouseup(dragDownUp);

        document.getElementById("dragHandlerId").addEventListener('touchstart',dragDownFun);
        document.getElementById("dragHandlerId").addEventListener('touchmove',dragMoveFun);        
        document.getElementById("dragHandlerId").addEventListener('touchend',dragDownUp);
        
        function dragDownFun(e){
        	$.fn.drag.prototype.st = (new Date()).valueOf();
            isMove = true;
            if(typeof(e.touches)=="undefined"){
                x = e.pageX - parseInt(handler.css('left'), 10);
            }else{
            	x = e.touches[0].pageX - parseInt(handler.css('left'), 10);
            }
        }
        
        function dragDownUp(e){
            isMove = false;
            var _x = parseInt(handler.css('left'), 10);
            if(_x < maxWidth){ //鼠标松开时，如果没有达到最大距离位置，滑块就返回初始位置
                handler.css({'left': 0});
                drag_bg.css({'width': 0});
            }
        }
        
        function dragMoveFun(e){
            var _x = 0;
            if(typeof(e.touches)=="undefined"){
                _x = e.pageX - x;
            }else{
            	_x = e.touches[0].pageX - x;
            }
            if(isMove){
                if(_x > 0 && _x <= maxWidth){
                    handler.css({'left': _x});
                    drag_bg.css({'width': _x});
                }else if(_x > maxWidth){  //鼠标指针移动距离达到最大时清空事件
                    handler.css({'left': maxWidth});
                    drag_bg.css({'width': maxWidth});
                    $.fn.drag.prototype.et = (new Date()).valueOf();
                    dragOk();
                }
            }
        }
        
        //清空事件
        function dragOk(){
            handler.find('span').removeClass('glyphicon-forward').addClass('glyphicon-ok-sign');
            text.text('验证通过');
            drag.css({'color': '#fff'});
            handler.css({'color':'#7ac23c'});
            handler.unbind('mousedown');
            $(document).unbind('mousemove');
            $(document).unbind('mouseup');
            setTimeout("getVerifyCodeF()",1000);
        }
    };
})(jQuery);