var socket;
var r;
var u;
var photoWidth;
var photoHeight;
$(function() {
	photoWidth = $(window).width() - 32;
	photoHeight = photoWidth / 4 * 3;
	if (photoWidth > 320) {
		photoWidth = 320;
		photoHeight = 240;
	}
	$('.photo').css({
		'width' : photoWidth + 'px',
		'height' : photoHeight + 'px',
		'margin' : '16px auto'
	});
	$('#openDoor').hide();

	json = res;
	if(typeof json == "string"){
		json = eval('('+json+')');
	}
	if(json.room == null){
		//提示获取失败
		$('.photo').empty();
		$('.photo').append('<div style="color:#EA3918;text-align:center;margin-top:30%;font-size:18px;">获取失败</div>');
		return;
	}
	if (json.room == 'ok') {
		//正常，可以通讯
		r = json.roomKey;
		u = json.me;
		createSocket(json.roomLink);
		if (socket == null) {
			//提示浏览器不支持
			$('.photo').empty();
			$('.photo').append('<div style="color:#EA3918;text-align:center;margin-top:30%;font-size:18px;">您的浏览器不支持该功能</div>');
			showHistoryBtn();
		}
	}else if(json.room == 'noroom'){
		//挂断提醒
		$('.photo').empty();
		$('.photo').append('<div style="color:#EA3918;text-align:center;margin-top:30%;font-size:18px;">已挂断</div>');
		showHistoryBtn();
	}else if(json.room == 'busy'){
		//占线提醒
		$('.photo').empty();
		$('.photo').append('<div style="color:#EA3918;text-align:center;margin-top:30%;font-size:18px;">占线</div>');
		showHistoryBtn();
	}

	$('#openDoor').click(function(){
		var msg = '{"r":"' + r + '","u":"' + u + '","t":"mobile","m":"openDoor"}';
		send(msg);
	});
	
	window.onbeforeunload = function() {
		close();
	};
});

function send(message) {
	//{"r":"房间","u":"自己的信息，服务器分配的","t":"自己的类型","m":"请求或回复信息"}
	if (!window.WebSocket || socket==null) {
		return;
	}
	if (socket.readyState == WebSocket.OPEN) {
		console.log("发送："+message);
		socket.send(message);
	} else {
		console.log("WebSocket 连接没有建立成功！");
	}
}
function close(){
	//提示结束
	console.log("结束");
	if (!window.WebSocket || socket==null) {
		return;
	}
	socket.close();
	socket=null;
}

function createSocket(wsURL) {
	if (!window.WebSocket) {
		window.WebSocket = window.MozWebSocket;
	}
	if (window.WebSocket) {
		socket = new WebSocket(wsURL);
		socket.onmessage = function(event) {
			console.log(event.data);
			var m = event.data;
			if(m=='closeRoom') {
				//挂断提醒
				if($('#roomTips').text()=='门锁已开'){
					$('#roomTips').text('门锁已开 - 对方已挂断');
				}else{
					$('#roomTips').text('已挂断');
					showHistoryBtn();
                    $('#openDoor').hide();
				}
				close();
			}else if(m=='ok') {
				//开锁成功
				$('#roomTips').text('门锁已开');
				$('#openDoor').hide();
			}else if(m.indexOf('http')>=0){
				//获取到快照
				$('.photo').empty();
				$('.photo').append('<img style="width:'+photoWidth+'px;height:'+photoHeight+'px;" src="'+m+'">');
				$('#openDoor').show();
			}
		};
		socket.onopen = function(event) {
			console.log("WebSocket 建立成功！");
			var msg = '{"r":"' + r + '","u":"' + u + '","t":"mobile","m":"url"}';
			send(msg);
		};
		socket.onclose = function(event) {
			if($('#roomTips').text().indexOf('门锁已开')>=0){
				$('#roomTips').text('门锁已开 - 对方已挂断');
			}else{
				$('#roomTips').text('已挂断');
				showHistoryBtn();
			}
			$('#openDoor').hide();
			close();
		};
	}
}
function showHistoryBtn(){
    if ( $(".queryCallListBtn").length <= 0 ) {
        $('.photo').append('<div class="btn mybtn-default queryCallListBtn" onclick="showHistory();" style="width:50%;margin-top:50px;margin-bottom: 20px;">查看呼叫历史</div>');
	}

}
function showHistory(){
	window.location.href=ctx+'/doorbell/callhistory/'+userId+'/1';
}