//@ sourceURL=comm_menu.js
$(function(){

	/**
	 * 打开小区基本信息列表
	 * 当用户点击小区管理/小区基本信息菜单项时，调用该函数 
	 * 菜单项目ID命名规范:menu-xxx--page
	 */
	$('#menu-community-page').parent().click(function(){
		$.ajax({
			type:"POST",
			cache: false,
			url:ctx+"/adm/community/list",
			data:"",
			success:function(msg){
				addPage(msg);
			},
			complete:function(){
				waitingStop();
				closeLeftMenu();
			},
			beforeSend:function(){
				waiting();
			}
		});
	});
	/**
	 * 打开楼栋基本信息列表
	 * 当用户点击楼栋管理/楼栋基本信息菜单项时，调用该函数 
	 * 菜单项目ID命名规范:menu-xxx--page
	 */
	$('#menu-build-page').parent().click(function(){
		$.ajax({
			type:"POST",
			cache: false,
			url:ctx+"/adm/build/list",
			data:"",
			success:function(msg){
				addPage(msg);
			},
			complete:function(){
				waitingStop();
				closeLeftMenu();
			},
			beforeSend:function(){
				waiting();
			}
		});
	});

	/**
	 * 打开门基本信息列表
	 * 当用户点击门管理/门基本信息菜单项时，调用该函数
	 * 菜单项目ID命名规范:menu-xxx--page
	 */
	$('#menu-door-page').parent().click(function(){
		$.ajax({
			type:"POST",
			cache: false,
			url:ctx+"/adm/door/list",
			data:"",
			success:function(msg){
				addPage(msg);
			},
			complete:function(){
				waitingStop();
				closeLeftMenu();
			},
			beforeSend:function(){
				waiting();
			}
		});
	});
	



	
	/**
	 * 打开房间基本信息列表
	 * 当用户点击用户域管理/用户域基本信息菜单项时，调用该函数
	 * 菜单项目ID命名规范:menu-xxx--page 
	 */
	$('#menu-cell-page').parent().click(function(){
		$.ajax({
			type:"POST",
			cache: false,
			url:ctx+"/adm/cell/list",
			data:"",
			success:function(msg){
				addPage(msg);
			},
			complete:function(){
				waitingStop();
				closeLeftMenu();
			},
			beforeSend:function(){
				waiting();
			}
		});
	});
	
	/**
	 * 打开房间和用户表格导入导出页面
	 * 
	 * 菜单项目ID命名规范:menu-xxx--page 
	 */
	$('#import-user-page').parent().click(function(){
		$.ajax({
			type:"POST",
			cache: false,
			url:ctx+"/adm/excel/user_cell",
			data:"",
			success:function(msg){
				addPage(msg);
			},
			complete:function(){
				waitingStop();
				closeLeftMenu();
			},
			beforeSend:function(){
				waiting();
			}
		});
	});
	
    /**
	 * 打开资讯列表
	 * 菜单项目ID命名规范:menu-xxx--page
     */
	/*$("#menu-notice-page").parent().click(function () {
        $.ajax({
            type:"POST",
            cache: false,
            url:ctx+"/adm/news/query_notice_by_communityid",
            data:"",
            success:function(msg){
                addPage(msg);
            },
            complete:function(){
                waitingStop();
                closeLeftMenu();
            },
            beforeSend:function(){
                waiting();
            }
        });
    });*/


});

var tipsTimeoutTime;
var tipsTimeoutTimer; 
function tipsTimeout(){
	var temp = 
	'<div class="modal"  id="tipsTimeoutModal">'+
    '	<div class="modal-dialog  modal-sm" style="margin-top:15%">'+
    '   	<div class="modal-content model-linear">'+
	'			<div class="modal-body modal-oneline-body" style="padding: 8px;">'+
	'			会话超时，<span id="tipsTimeoutTime" style="font-size:20px;color:#fff;"></span>秒后请重新登录'+
	'			</div>'+
	'		</div>'+
	'	</div>'+
	'</div>';
	if($("#tipsTimeoutModal").length==0){
		$("div.viewFramework-body").append(temp);
	}
	var dialogWidth = $("#tipsTimeoutModal").find('.modal-dialog').width();
	$("#tipsTimeoutModal").find('.modal-dialog').css({
		'margin-left': function () {
			return ($(window).width() - dialogWidth + $('div.viewFramework-sidebar').width())/2;
		}
	});
}

function tipsTimeoutTimerFunction(){	
	tipsTimeoutTime--;
	if(tipsTimeoutTime <= 0){ 
		var ref = window.location.href;
		if(ref.indexOf('#')>0){
			ref = ref.replace('#','');
		}
		if(ref.indexOf('/') == ref.length-1){
			ref = ref.Substring(0,ref.length-1);
		}
		$("#tipsTimeoutModal").css("display","none");
		window.clearInterval(tipsTimeoutTimer);
		window.location.href = ref+'/';
	}else{
		$("#tipsTimeoutTime").text(tipsTimeoutTime);
	}
}

/**
 * 向工作区域添加面板
 */
function addPage(msg) {
	var json = isJsonObject(msg);
	if(json && msg.code != 0){
		openTipLayer(msg.msg);
		return;
	}
	if(isOK(msg)){
		$("#work_area").empty();
		$("#work_area").append('<div id="work_areashade" class="modelshade">	</div>'+msg);
		$("#work_areashade").hide();
		scrollPane();
		return true;
	}
	return false
}

function isOK(msg){
	// 验证登录超时
	if(msg!=null && typeof msg == "string" && msg.indexOf('<form name="admin_login">')>0){
		if(tipsTimeoutTimer==null){
			tipsTimeoutTime = 5;
			tipsTimeout();
			$("#tipsTimeoutTime").text(tipsTimeoutTime);
			$("#tipsTimeoutModal").css("display","block");
			tipsTimeoutTimer = window.setInterval("tipsTimeoutTimerFunction()",1000);
		}
		return false;
	}

	// 验证业务失败时
    var json = isJsonObject(msg);
    if(json && msg.code != 0){
        openTipLayer(msg.msg);
        return false;
    }

	return true;
}

/*
 * 判断是否json对象
 */
function isJsonObject(obj){
	var isjson = typeof(obj) == "object" && Object.prototype.toString.call(obj).toLowerCase() == "[object object]" && !obj.length; 
	return isjson;
}

/**
 * 弹出通知
 * @param content
 */
function openTipLayer(content){
	var str='<div style="width:250px;height:100px; text-align:center;background:#527cd3;color:#FFFFFF;font-family:Arial;font-size:20px;line-height:100px; ">'+content+'</div>';
	var wi=($(window).width() - 250 + $('div.viewFramework-sidebar').width())/2;
	var he=$(window).height() / 2 - 50;
	layer.open({
	    type: 1,//页面层
	    title: false, //不显示标题
	    time: 4000,//自动关闭时间 4秒
	    area: ['auto', 'auto'], //大小 
	    offset: [he+'px', wi+'px'],//坐标
	    skin: 'tips-layerdialog', //样式类名
	    closeBtn: 0, //不显示关闭按钮
	    shift: 2,//动画从下往上弹出
	    shade: 0,//不显示遮罩
	    shadeClose: true, //开启遮罩关闭
	    content: str
	});
}