//用于记录table行号，判断双击事件
var tr_index = -1;
$(function(){
	
	//设置表格高度为自适应
	setTableHeigh();
	/*绑定全选事件*/
	$('table > thead > tr > th:eq(0)').addClass('checked');
	$('table > thead > tr > th:eq(0)').click(function(){		
		if($(this).hasClass('checked')){			
			$(this).find(":checkbox").prop('checked',true);
			$(this).removeClass('checked');
		}else{			
			$(this).find(":checkbox").prop('checked',false);
			$(this).addClass('checked');
		}
		/*判断全选器是否被选中*/
		if($(this).find(":checkbox").is(':checked')){			
			selectAll();
		}else{			
			unSelectAll();
		}
	});
	//控制搜索表单的显示和隐藏
	searchSwitch();
	
});

/*******************************以下代码为普通函数*******************************************/
/**计算表格高度*/
function setTableHeigh(){
	var h = $("div.panel").find("table").outerHeight(true);	
	//列表panel高度	
	$("div.panel").css({
		'height': h+50+'px'
	});
    //回填panel高度	
	$("div.backfill").css({
		'height': h+70+'px'
	});
}

/**设置弹窗垂直居中**/
function middleModal(modalId){
	var modalWidth = $('#'+modalId).find('.modal-dialog').width();
	$('#'+modalId).find('.modal-dialog').css({
		'margin-left': function () {
			return ($(window).width() - modalWidth + $('div.viewFramework-sidebar').width())/2;
		}
	});
	$('#'+modalId).on('shown.bs.modal', function () {
		var modalHeight = $('#'+modalId).find('.modal-dialog').outerHeight(true);
		$(this).css({
			'padding-top': function () {
				return ($(window).height() / 2 - modalHeight/2);
			}
		});
	});
}

/**
 * 弹出窗口，且水平垂直方向居中
 */
function openWin(divId){
	//计算出屏幕宽度
	var display_w = $(window).width();
	var display_h = $(window).height();
	//计算出左菜单宽度
	var left_menu_w = $('.leftsidebar_box').width();
	//计算出当前div宽度	
	var wk_w = display_w - left_menu_w;
	var div_h = $("#"+divId).outerHeight(true);
	var div_w = $("#"+divId).outerWidth(true);
	var positionX = (wk_w-div_w)/2 + left_menu_w;
	var positionY = (display_h - div_h)/2;
	var myOffset = new Object();
	myOffset.left = positionX;
	myOffset.top = positionY;
	$("#"+divId).offset(myOffset);
}

/**
 * 关闭指定div
 * @param divId
 */
function closeWin(divId){
	$('#'+divId).remove();
	$("#work_areashade").hide();
}

/**
 * 全选
 */
function selectAll(){	
	$("table > tbody > tr > td :checkbox").prop('checked',true);	
}

/**
 * 全部取消
 */
function unSelectAll(){	
	$("table > tbody > tr > td :checkbox").prop('checked',false);	
}

/**
 * 删除表格中的数据，表格的规格需要满足规范
 * table > tbody > tr > td > input[type=checkbox]
 * @para url 为提交给Controller的请求地址
 */
function remove(url,para){
    var ids = [];
    var data;
    console.log(isNull(para));
    if(isNull(para)){
        data = {};
    }else{
        data = para;
    }

    $('table > tbody > tr > td > input[type=checkbox]').each(function(){
        var input = $(this);
        if(input.is(':checked')){
            ids.push(input.val());
        }
    });
    $('table > tbody > tr > td > input[type=radio]').each(function(){
        var input = $(this);
        if(input.is(':checked')){
            ids.push(input.val());
        }
    });
    data['ids']=ids.join(',');
    doDataPost(data, false, url, function(json){
        var msgJson = isJsonObject(json);
        if(msgJson == false){
            //     closeWin("news_check_div");
            $("#work_area").append(json);
        }else if(typeof(json)=='string'){
            var json = $.parseJSON(json);
            openTipLayer(json.msg);
            if (json.code == '0') {
                //需要重新查询
                $.each(ids, function(index, value) {
                    $(':checkbox[value='+value+']').parent().parent().remove();
                });
            }
        }else{
            if (json.code == '0') {
                openTipLayer(json.msg);
                //需要重新查询
                $.each(ids, function(index, value) {
                    $(':checkbox[value='+value+']').parent().parent().remove();
                    $(':radio[value='+value+']').parent().parent().remove();
                });
            } else {
                myAlert(json.msg);
            }
        }

    });
}




/**
 * 删除表格中的数据，表格的规格需要满足规范
 * table > tbody > tr > td > input[type=checkbox]
 * @para url 为提交给Controller的请求地址
 */
function removeAndRefresh(url,callback){
    var ids = [];
    var data={};
    $('table > tbody > tr > td > input[type=checkbox]').each(function(){
        var input = $(this);
        if(input.is(':checked')){
            ids.push(input.val());
        }
    });
    $('table > tbody > tr > td > input[type=radio]').each(function(){
        var input = $(this);
        if(input.is(':checked')){
            ids.push(input.val());
        }
    });
    data['ids']=ids.join(',');
    doDataPost(data, false, url, function(json){
        var msgJson = isJsonObject(json);
        if(msgJson == false){
            //     closeWin("news_check_div");
            $("#work_area").append(json);
        }else if(typeof(json)=='string'){
            var json = $.parseJSON(json);
            openTipLayer(json.msg);
            if (json.code == '0') {
                //需要重新查询
                if(callback) callback();
            }
        }else{
            if (json.code == '0') {
                openTipLayer(json.msg);
                //需要重新查询
                if(callback) callback();
            } else {
                myAlert(json.msg);
            }
        }

    });
}

/**
 * 弹出通知
 * @param content
 */
function openTipLayer(content){
	var str='<div style="width:250px;height:100px; text-align:center;background:#527cd3;color:#FFFFFF;font-family:Arial;font-size:20px;line-height:100px; ">'+content+'</div>';
	var wi=($(window).width() - 250 + $('div.viewFramework-sidebar').width())/2;
	var he=$(window).height() / 2 - 50;
	layer.open({
	    type: 1,//页面层
	    title: false, //不显示标题
	    time: 3000,//自动关闭时间 3秒
	    area: ['auto', 'auto'], //大小 
	    offset: [he+'px', wi+'px'],//坐标
	    skin: 'tips-layerdialog', //样式类名
	    closeBtn: 0, //不显示关闭按钮
	    shift: 2,//动画从下往上弹出
	    shade: 0,//不显示遮罩
	   // shadeClose: true, //开启遮罩关闭
	    content: str
	});
}

/**
 * 向工作区域添加表单模态框
 */
function addForm(msg) {	
	try {
    	var msgJson = isJsonObject(msg);
    	if(msgJson == false){
    		$("#work_area").find(".modal").remove();
    		 $("#work_area").append(msg);    		 
    	}else{
    		$("#work_areashade").hide();
    		if(msg.code != 0){    			
    			openTipLayer(msg.msg);
    			return;
    		}   		    
    	}      
	} catch (e) {
		console.log(e);
	}
}
/*
 * 判断是否json对象
 */
function isJsonObject(obj){
	var isjson = typeof(obj) == "object" && Object.prototype.toString.call(obj).toLowerCase() == "[object object]" && !obj.length; 
	return isjson;
}

/**
 * 向工作区添加回填列表
 */
function addBackfill(listId,msg){
	//$("#work_area").find("#"+listId).remove();
	$("#work_area").append(msg);
}
/**
 * param 将要转为URL参数字符串的对象
 * key URL参数字符串的前缀
 * encode true/false 是否进行URL编码,默认为true * 
 * return URL参数字符串
 */
function urlEncode(param, key, encode) {
  if(param==null) return '';
  var paramStr = '';
  var t = typeof (param);
  if (t == 'string' || t == 'number' || t == 'boolean') {
    paramStr += '&' + key + '=' + ((encode==null||encode) ? encodeURIComponent(param) : param);
  } else {
    for (var i in param) {
      var k = key == null ? i : key + (param instanceof Array ? '[' + i + ']' : '.' + i);
      paramStr += urlEncode(param[i], k, encode);
    }
  }
  return paramStr;
};

function isOK(msg){
	// 验证超时
	if(msg!=null && typeof msg == "string" && msg.indexOf('<form name="admin_login">')>0){
		if(tipsTimeoutTimer==null){
			tipsTimeoutTime = 5;
			tipsTimeout();
			$("#tipsTimeoutTime").text(tipsTimeoutTime);
			$("#tipsTimeoutModal").css("display","block");
			tipsTimeoutTimer = window.setInterval("tipsTimeoutTimerFunction()",1000);
		}
		return false;
	}

    // 验证业务失败时
    var json = isJsonObject(msg);
    if(json && msg.code != 0){
        openTipLayer(msg.msg);
        return false;
    }

	return true;
}


/**
 * 开关控制函数，用控件值控制其他元素是否显示 
 * @param data {
    "ctr":    "开关",  //JQ对象
    "view":   "受控元素" , //JQ对象
    "value": "boolean" //布尔值
   }
 */
function switchDisplay(data){
	var ctr = data.ctr;
	var view = data.view;
	var value = data.value;	
	var fun = data.fun;
	$(ctr).click(function(){
		var checked = $(this).is(':checked');
		if(checked){
			var v = $(this).val();
			if(v == value){
				$(view).css('display','inline-block');				
			}else{
				$(view).css('display','none');			
			}
		
		}	
		if(isExitsFunction(fun)){
			fun();
		}
	});
	
}

/**
 * 显示控制
 */
function switchView(data){	
	var ctr = data.ctrValue;
	var view = data.view;
	var value = data.value;
	var fun = data.fun;
	//console.log(fun);
	if(ctr == value){
		$(view).css('display','inline-block');				
	}else{
		$(view).css('display','none');			
	}
	if(isExitsFunction(fun)){		
		fun();
	}	
}


//是否存在指定函数 
function isExitsFunction(funcName) {
    try {
        if (typeof(eval(funcName)) == "function") {
            return true;
        }
    } catch(e) {}
    return false;
}
//是否存在指定变量 
function isExitsVariable(variableName) {
    try {
        if (typeof(variableName) == "undefined") {
            //alert("value is undefined"); 
            return false;
        } else {
            //alert("value is true"); 
            return true;
        }
    } catch(e) {}
    return false;
}

/**
 * 让查询框支持回车事件
 */ 
function enterKeydown(){
	
}

/** 
* 判断是否null 
* @param data 
*/
function isNull(data){ 
	return (data == "" || data == undefined || data == null) ? true : false; 
}

/**
 * 判断是否不为null
 * @param data 
 */

function notNull(data){
	return ! isNull(data);
}

/**
 * 弹出提示信息
 */ 
function myAlert(msg){	
	var x = ($(window).width() - 260 + $('div.viewFramework-sidebar').width())/2;
	var y = ($(window).height() / 2 - 73);
	layer.alert(msg, {
		  icon: 0,
		  title:'提示',
		  area: ['260px', '146px'],
		  offset: [y+'px', x+'px']
	}); 
}

/**
 * 弹出提示信息
 */
function myAlert(msg,width,height){
    var x = ($(window).width() - width + $('div.viewFramework-sidebar').width())/2;
    var y = ($(window).height() / 2 - height / 2);
    layer.alert(msg, {
        icon: 0,
        title:'提示',
        area: [width+'px', height+'px'],
        offset: 'auto'
    });
}

/**
 * 用于表单中过滤UTF-8编码格式中的4字节编码（它对应的是智能手机输入法中的表情）的正则表达式，此表达式为自定义的，可视情况修改。
 */
function getUtfRegexp(){
	return "^([\x09\x0A\x0D\x20-\x7E]|[\u4e00-\u9fa5]|[\uff0c\u3002\u3001\uff1b\u2019\u2018\u3010\u3011\u3001\uff1a\u201c\u201d\u300a\u300b\uff1f\uff01\u00b7\uffe5\u2026\uff08\uff09\u2014\u3007\u3000\u2103\uff5e])+$";
}



/**
 * 屏幕宽度小于768时隐藏搜索表单，显示搜索表单开关
 */
function searchSwitch(){
//	alert(screen.width);
//	console.log("屏幕宽度"+screen.width);
	if(screen.width<768){
		$(".form-search").hide();
		$(".search-switch").show();
		$(".search-switch").click(function(){
			$(".search-switch").hide();
			$(".form-search").show();
		});
	}else{
		$(".search-switch").hide();
		$(".form-search").show();
		
	}
}