$(function () {

    refreshMessage();

    $('.btn_search_more').click(function(){
        refreshMessage();
    });

    /*打开小区回填列表*/
    $('form[name=park_searcg_from] :input.form-select[name$=s_communityName]').click(function(){
        //回填表单对应的数据域,该函数需要回调者进行实现
        communityList.backfillFun = function (data){
            $('form[name=park_searcg_from] :input[type=hidden][name$=s_communityId]').val(data.id);
            $('form[name=park_searcg_from] :input[name$=s_communityName]').val(data.name);
        };
        var data={};
        communityList.data=data;
        communityList.popCommunityList(data);
    });

});

/**
 * 封装数字样式
 * @param number
 */
function wrapDigital(number) {
    var digitalArray = new Array(10);
    for (var i = 0; i <= 9; i ++) {
        digitalArray[i] = '<img src="/static/images/park/' + i + '.png"/>';
    }
    var s = new String(number);
    var result = '';
    for (var k = 0; k < s.length; k ++) {
        result += digitalArray[s.charAt(k)];
    }
    return result;
}

/**
 * 刷新页面列表（附搜索条件)
 */
function refreshMessage(){
    loadParkSpace();
    loadParkPay();
}

/**
 * 获取车位信息
 */
function loadParkSpace() {
    var communityId = $("#s_communityId").val();
    $.ajax({
        url: "/adm/park/ajax/space/message/today",
        type: "post",
        dataType: "json",
        data: {"s_communityId": communityId},
        success: function(data) {
            if (data.code == 0) {
                $("#total-space").html( wrapDigital(data.data.totalSpace) );
                $("#empty-space").html( wrapDigital(data.data.emptySpace) );
                $("#used-space").html( wrapDigital(data.data.usedSpace) );
            } else {
                console.log("车位信息获取错误：" + data.msg);
            }
        },
        error: function(e) {
            console.log("车位信息获取错误：" + e);
        }
    });
}

/**
 * 获取今日的临时收费总额
 */
function loadParkPay() {
    var communityId = $("#s_communityId").val();
    $.ajax({
        url: "/adm/ajax/park/temporary/pay/count/today",
        type: "post",
        dataType: "json",
        data: {"s_communityId": communityId},
        success: function(data) {
            if (data.code == 0) {
                $("#total-pay-tody").html( wrapDigital(data.data) )
            } else {
                console.log("车场收费总额错误：" + data.msg);
            }
        },
        error: function(e) {
            console.log("车场收费总额错误：" + e);
        }
    });
}