/**
 * 添加bootstrapValidator校验
 */
$(function() {
	$("form[name=door_edit_from]").bootstrapValidator({
		message : 'This value is not valid',
		excluded : [ ":hidden",':disabled' ],
		feedbackIcons : {
			valid : 'glyphicon glyphicon-ok',
			invalid : 'glyphicon glyphicon-remove',
			validating : 'glyphicon glyphicon-refresh'
		},
		fields : {
			'communityName' : {
				validators : {
					notEmpty : {
						message : '小区不能为空'
					}
				}
			},'buildName' : {
				validators : {
					notEmpty : {
						message : '小区不能为空'
					}
				}
			},'name':{
				validators : {
					notEmpty : {
						message : '名称不能为空'
					}, 
					regexp: {
                        regexp: getUtfRegexp(),
                        message: '含有非法字符'
                    }
				}
				
			}/*,'index':{
				validators : {
					notEmpty : {
						message : '编号不能为空'
					},				
	                regexp: {
	                	regexp: /^(0|\+?[1-9][0-9]{0,2})$/,                 
	                    message: '门编号只能为非负整数且不能超过 3位数'
	                }
				}
			}*/
		}
	});
});

$(function(){
	//点击表单ok按钮
	$('#btn_ok').click(function(){
		//表单数据格式合法性验证
		$("form[name=door_edit_from]").bootstrapValidator('validate');
		var valid = $("form[name=door_edit_from]").data('bootstrapValidator').isValid();
		if(!valid){
			return;
		}

        var inputs = $("form[name=door_edit_from] :input");
        var data = {};
        $(inputs).each(function(){
            var input = $(this);
            if(this.tagName.toLowerCase()==='input' && this.type.toLowerCase()==='radio'){
                //如果是radio 取选中的值
                if(this.checked){
                    data[input.attr('name')]=input.val();
                }
            }else{
                data[input.attr('name')]=input.val();
            }
        });

		//检查门编号是否发生变化
		// var oldDoorIndex=$("#oldDoorIndex").val();
		// if(oldDoorIndex!=data.index){
		// 	var x = ($(window).width() - 260 + $('div.viewFramework-sidebar').width())/2;
		// 	var y = ($(window).height() / 2 - 73);
		// 	layer.confirm('检测到门编号发生变化，门编号变化后需要重新初始化设备，是否继续？', {
		// 		icon: 3,
		// 		title:'提示' ,
		// 		btn: ['确定','取消'], //按钮
		// 	  area: ['320px', '170px'],
		// 	  offset: [y+'px', x+'px']
		// 	}, function(index){
         //        doDataPost(data,false,ctx+"/adm/door/upd",function(json){
		// 			//var json=$.parseJSON(repJson);
		// 			openTipLayer(json.msg);
		// 			if(json.code==0){
		// 				refreshList();
		// 				closeWin("door_eidt_div");
		// 			}
		// 		});
		// 	    layer.close(index);
		// 	});
		//
		// }else{

			 doDataPost(data, false, ctx+"/adm/door/upd", function(json){
//					var json=$.parseJSON(repJson);
					openTipLayer(json.msg);
					if(json.code==0){
						refreshList();
						closeWin("door_eidt_div");
					}
					
				});
		// }
		
		
	});

	//点击关闭按钮，关闭当前弹出窗口
	$('#btn_cancel').click(function(){
		closeWin("door_edit_div");
	});

	// /*打开小区回填列表*/
	// $('form[name=door_edit_from] :input.form-select[name$=communityName]').click(function(){
	// 	//回填表单对应的数据域,该函数需要回调者进行实现
	// 	communityList.backfillFun = function (data){
	// 		$('form[name=door_edit_from] :input[type=hidden][name$=communityId]').val(data.id);
	// 		$('form[name=door_edit_from] :input[name$=communityName]').val(data.name);
	// 		//需要收工触发onchange事件
	// 		$('form[name=door_edit_from] :input[type=hidden][name$=communityId]').change();
	// 		revalidate('communityName');
	// 		var doorType = $("#doorType").val();
	// 		if(doorType==1){
	// 			$("#doorName").val(data.name+"小区门");
	// 		}
	// 	};
	// 	var data={};
	// 	communityList.data=data;
	// 	communityList.popCommunityList(data);
	// });
    //
	// /*打开小区回填列表*/
	// $('#buildName').click(function(){
	// 	var communityId=$('#communityId').val();
	// 	if(communityId==null || communityId.length<=0){
	// 		alert("请先选择小区");
	// 		return;
	// 	}
	// 	var data={"communityId":communityId};
	// 	buildList.data=data;
	// 	buildList.popBuildList(data);
	//
	// 	//回填表单对应的数据域,该函数需要回调者进行实现
	// 	buildList.backfillFun = function (data){
	// 		$('#buildId').val(data.id);
	// 		$('#buildName').val(data.name);
	// 		revalidate('buildName');
	// 		var doorType = $("#doorType").val();
	// 		if(doorType==0){
	// 			$("#doorName").val(data.name+"楼栋门");
	// 		}
	// 	}
	// });
	showBuildSelection();
	
	// /**
	//  * 是否显示楼栋
	//  */
    // $(":radio[name$=doorType]").click(function(){
	// 	 if(this.value==='BUILD_DOOR'){
	// 		 $("#buildRow").show();
	// 		 // $('form[name=door_edit_from] :input[type=hidden][name$=hiddenType]').val("0");
	// 	 }else if(this.value==='COMMUNITY_DOOR'){
	// 		 $("#buildRow").hide();
	// 		 // $('form[name=door_edit_from] :input[type=hidden][name$=hiddenType]').val("1");
	// 	 }
	// });

    // 根据门类型显示小区门或者楼栋门
    var doorType = $("#doorType").val();
    if (doorType == 1) {
        $(":radio[value='COMMUNITY_DOOR']").attr('checked','true');
    } else if(doorType == 0) {
        $(":radio[value='BUILD_DOOR']").attr('checked','true');
    }

    var doorRemote= $("#hidden_remote").val();
    if (doorRemote == 1) {
        $(":radio[value='1']").attr('checked','true');
    } else if(doorRemote == 0) {
        $(":radio[value='0']").attr('checked','true');
    }
});

/**
 * 需要重新验证数据
 */
function revalidate(field){
	//程序回填域需要调用如下函数通知bootstrapValidator校验框架
	$('form[name=door_edit_from]').data('bootstrapValidator')
     .updateStatus(field, 'NOT_VALIDATED', null)
     .validateField(field); 
}

function showBuildSelection() {
    var doorType = $("#doorType").val();
    if (doorType == 1) {
        $("#buildRow").hide();
    } else if(doorType == 0) {
        $("#buildRow").show();
    }
}