/**
 * 添加bootstrapValidator校验
 */
$(function() {
	$("form[name=door_add_from]").bootstrapValidator({
		message : 'This value is not valid',
		excluded : [ ":hidden",':disabled' ],
		feedbackIcons : {
			valid : 'glyphicon glyphicon-ok',
			invalid : 'glyphicon glyphicon-remove',
			validating : 'glyphicon glyphicon-refresh'
		},
		fields : {
			'communityName' : {
				validators : {
					notEmpty : {
						message : '小区不能为空'
					}
				}
			},'buildName' : {
				validators : {
					notEmpty : {
						message : '小区不能为空'
					}
				}
			},'name':{
				validators : {
					notEmpty : {
						message : '名称不能为空'
					}, 
					regexp: {
                        regexp: getUtfRegexp(),
                        message: '含有非法字符'
                    }
				}
				
			}/*,'index':{
				validators : {
					notEmpty : {
						message : '编号不能为空'
					},				
	                regexp: {
	                	regexp: /^(0|\+?[1-9][0-9]{0,2})$/,               
	                    message: '门编号只能为非负整数且不能超过 3位数'
	                }
				}
				
			}*/
		
		}
	});
});

$(function(){
    // 封装小区与楼栋的名称和id
    $("#currentDoorOfCommunityName").val($("#currentManageCommunityName").val());
    $("#currentDoorOfCommunityId").val($("#currentManageCommunityId").val());
    // $("#currentDoorOfBuildName").val($("#buildName"));
    // $("#currentDoorOfBuildId").val($("#buildId"));

	//点击表单ok按钮
	$('#btn_ok').click(function(){
		//表单数据格式合法性验证
		$("form[name=door_add_from]").bootstrapValidator('validate');
		var valid = $("form[name=door_add_from]").data('bootstrapValidator').isValid();
		if(!valid){
			return;
		}

        var inputs = $("form[name=door_add_from] :input");
        var data = {};
        $(inputs).each(function(){
            var input = $(this);
            if(this.tagName.toLowerCase()==='input' && this.type.toLowerCase()==='radio'){
                //如果是radio 取选中的值
                if(this.checked){
                    data[input.attr('name')]=input.val();
                }
            }else{
                data[input.attr('name')]=input.val();
            }
        });
        doDataPost(data, false, ctx+"/adm/door/add", function(json){
//					var json=$.parseJSON(repJson);
            openTipLayer(json.msg);
            if(json.code==0){
                refreshList();
                closeWin("door_add_div");
            }

        });


	});

	//点击关闭按钮，关闭当前弹出窗口
	$('#btn_cancel').click(function(){
		closeWin("door_add_div");
	});


	/*打开小区回填列表*/
	$('form[name=door_add_from] :input.form-select[name$=communityName]').click(function(){
		//回填表单对应的数据域,该函数需要回调者进行实现
		communityList.backfillFun = function (data){
			$('form[name=door_add_from] :input[type=hidden][name$=communityId]').val(data.id);
			$('form[name=door_add_from] :input[name$=communityName]').val(data.name);
			//需要收工触发onchange事件
			$('form[name=door_add_from] :input[type=hidden][name$=communityId]').change();
			
			revalidate('communityName');
			var doorType=$('form[name=door_add_from] :input[type=hidden][name$=hiddenType]').val();
			if(doorType==1){
				$("#doorName").val(data.name+"小区门");
			}
		}
		var data={};
		communityList.data=data;
		communityList.popCommunityList(data);
	});
	

	/*打开小区回填列表*/
	$('#buildName').click(function(){
		var communityId=$('#communityId').val();
		if(communityId==null || communityId.length<=0){
			alert("请先选择小区");
			return;
		}
		var data={"communityId":communityId};
		buildList.data=data;
		buildList.popBuildList(data);
		
		//回填表单对应的数据域,该函数需要回调者进行实现
		buildList.backfillFun = function (data){
			$('#buildId').val(data.id);
			$('#buildName').val(data.name);
			revalidate('buildName');
			var doorType=$('form[name=door_add_from] :input[type=hidden][name$=hiddenType]').val();
			if(doorType==0){
				$("#doorName").val(data.name+"楼栋门");
			}
		}
	});


	$("#serialNumber").bind("input propertychange change",function (event) {
        var buildName =$('#buildName').val();
        var communityName = $("#communityName").val();
        var checkedVal = $('form[ name=door_add_from ] :input[type=radio][name=type]:checked').val();
        if(checkedVal == '1'){
            if(communityName == null || communityName.length<=0){
                alert("请选择小区");
                // $('#serialNumber').val('');
                // revalidate('index');
                return;
            }
            // var number = $('#serialNumber').val();
            $("#doorName").val(communityName+"小区门");
            revalidate('name');
            return;
        }
        if(checkedVal == '0'){
            if(buildName==null|| buildName.length<=0){
                alert("请先选择楼栋");
                // $('#serialNumber').val('');
                // revalidate('index');
                return;
            }
            // var number = $('#serialNumber').val();
            $("#doorName").val(buildName+"楼栋门");
            revalidate('name');
        }
    });
	
	/**
	 * 是否选择置顶图片
	 */
	$(':input[type="radio"][name$=type]').click(function(){
		var doorName="";
		 if(this.value=='0'){
			 $("#buildRow").show();
			 $('form[name=door_add_from] :input[type=hidden][name$=hiddenType]').val("0");
			 doorName=$("#buildName").val()+"楼栋门";
       }else if(this.value=='1'){
      	 	$("#buildRow").hide();
      	 	$('form[name=door_add_from] :input[type=hidden][name$=hiddenType]').val("1");
      	 	doorName=$("#communityName").val()+"小区门";
       }
		 $("#doorName").val(doorName);
	});
	
	
	
});

/**
 * 需要重新验证数据
 */
function revalidate(field){
	//程序回填域需要调用如下函数通知bootstrapValidator校验框架
	$('form[name=door_add_from]').data('bootstrapValidator')
     .updateStatus(field, 'NOT_VALIDATED', null)
     .validateField(field); 
}
