
$(function(){

	//点击表单ok按钮
	$('#btn_ok').click(function(){
        closeWin("community_edit_div");
		
	});
	
	/**
	 * 点击关闭按钮，关闭当前弹出窗口
	 */
	$('#btn_cancel').click(function(){
		closeWin("community_edit_div");
	});

	//选项卡点击事件
	$(".nav-tabs li").click(function(){
		$(".nav-tabs li").removeClass("active");
		$(this).addClass("active");
		var tabid=this.id;
		$(".form-divs").hide();
		if(tabid=="tab-info"){
			$("#div-info").show();
		}else if(tabid=="tab-services"){
			$("#div-services").show();
            scrollForm();
		}else if(tabid=="tab-doorbellconfigure"){
			$("#div-doorbellconfigure").show();
			scrollForm();
		}else if(tabid=="tab-enclosureconfigure"){
			$("#div-enclosureconfigure").show();
			scrollForm();
		}else if(tabid=="tab-telephone"){
			$("#div-telephone").show();
			scrollForm();
		}
	});
	$("#tab-info").click();

	
	//门口机型号
	$("#doorbellType").change(function(){
		//根据门口机型号 设置默认设备配置
		setDoorbellByJson($(this).val());
	});
	//围墙机型号
	$("#enclosureType").change(function(){
		//根据围墙机型号 设置默认设备配置
		setEnclosureByJson($(this).val())
	});
	
	
	initServices();

	initConfigure();
	
	setReadOnly();
});


/**
 * 初始化小区功能配置页面
 */
function initServices(){
	
	var dataroot=ctx+"/static/json/services.json?randID=" + Math.random();
	//设置为同步
	$.ajaxSettings.async = false;
	$.getJSON(dataroot, function(data){ 
		//设备型号
		var doorbellhtml='<option value="">---门口机型号---</option>';
		var doorbellJson=data.machineType.doorbell;
		var enclosurehtml='<option value="">---围墙机型号---</option>';
		var enclosureJson=data.machineType.enclosure;
		for(i=0;i<doorbellJson.options.length;i++){
			doorbellhtml+='<option value="'+doorbellJson.options[i]+'">'+doorbellJson.options[i]+'------'+doorbellJson.optionsIntroduction[i]+'</option>';
			
		}
		for(i=0;i<enclosureJson.options.length;i++){
			enclosurehtml+='<option value="'+enclosureJson.options[i]+'">'+enclosureJson.options[i]+'------'+enclosureJson.optionsIntroduction[i]+'</option>';
		}
		$("#doorbellType").html(doorbellhtml);
		$("#enclosureType").html(enclosurehtml);
		selectCheck("doorbellType",$("#doorbellType_hv").val());
		selectCheck("enclosureType",$("#enclosureType_hv").val());
		initDoorbellTalkVideo($("#doorbellType_hv").val());
		initEnclosureTalkVideo($("#enclosureType_hv").val());
		
		var servicehtml='';
        var specialmodelshtml='';
		for(i=0;i<data.services.length;i++){
            if(data.services[i].serviceValue=="XinjiangModel" || data.services[i].serviceValue=="GZAJBModel"){
                specialmodelshtml+='<div class="col-sm-4 col-md-4 col-lg-4" style="margin-top: 10px;">'+
                    '<input class="serviceCheckbox checkbox-input" type="checkbox" disabled="disabled" name="services" id="'+data.services[i].serviceValue+'" value="'+data.services[i].serviceValue+'"/>'+
                    '<label class="checkbox-label" for="'+data.services[i].serviceValue+'" >'+data.services[i].serviceName+'</label></div>';
			}else{
                servicehtml+='<div class="col-sm-4 col-md-4 col-lg-4" style="margin-top: 10px;">'+
                    '<input class="serviceCheckbox checkbox-input" type="checkbox" disabled="disabled" name="services" id="'+data.services[i].serviceValue+'" value="'+data.services[i].serviceValue+'"/>'+
                    '<label class="checkbox-label" for="'+data.services[i].serviceValue+'" >'+data.services[i].serviceName+'</label></div>';
			}

		
		}
		
		$("#servicesrow").html(servicehtml);
        $("#specialmodelsrow").html(specialmodelshtml);

		var services=$("#servicesStr").val();
		
		$(".serviceCheckbox").each(function () {
			var service=$(this).val();
			if(services.indexOf(service)>0){
				this.checked = "checked"; 
			}
			
	    });

        if (services.indexOf('doorCardTypeID') > 0) {
            $("#doorCardType").val("doorCardTypeID");
        }else{
            $("#doorCardType").val("doorCardTypeIC");
        }
	}); 
	
	
}

/**
 * 初始化设备配置页面
 */
function initConfigure(){
	
	//门口机远程开锁是否需要手动确认
	radioCheck("doorbell_lockAuto",$("#doorbell_lockAuto").val());
	//门口机是否设置为按键板
	radioCheck("doorbell_keyboard",$("#doorbell_keyboard").val());
	//门口机是否抓拍云存储
	radioCheck("doorbell_upPic",$("#doorbell_upPic").val());
	//门口机是否显示二维码扫描框
	radioCheck("doorbell_qcScanningFrame",$("#doorbell_qcScanningFrame").val());
	//门口机是否近距离开门
	radioCheck("doorbell_distanceswitch",$("#doorbell_distanceswitch").val());
	//门口机对讲视频分辨率(夜视)
	selectCheck("doorbell_blackAndWhite",$("#doorbell_blackAndWhite_hv").val());
	//门口机对讲视频分辨率(彩色)
	selectCheck("doorbell_color",$("#doorbell_color_hv").val());
	//门口机门锁类型
	selectCheck("doorbell_lockType",$("#doorbell_lockType_hv").val());
	//门口机门卡数据类型
	selectCheck("doorbell_cardDataType",$("#doorbell_cardDataType_hv").val());
	
	//围墙机远程开锁是否需要手动确认
	radioCheck("enclosure_lockAuto",$("#enclosure_lockAuto").val());
	//围墙机是否设置为按键板
	radioCheck("enclosure_keyboard",$("#enclosure_keyboard").val());
	//围墙机是否抓拍云存储
	radioCheck("enclosure_upPic",$("#enclosure_upPic").val());
	//围墙机是否显示二维码扫描框
	radioCheck("enclosure_qcScanningFrame",$("#enclosure_qcScanningFrame").val());
	//围墙机是否近距离开门
	radioCheck("enclosure_distanceswitch",$("#enclosure_distanceswitch").val());
	//围墙机对讲视频分辨率(夜视)
	selectCheck( "enclosure_blackAndWhite",$("#enclosure_blackAndWhite_hv").val());
	//围墙机对讲视频分辨率(彩色)
	selectCheck("enclosure_color",$("#enclosure_color_hv").val());
	//围墙机门锁类型
	selectCheck("enclosure_lockType",$("#enclosure_lockType_hv").val());
	//围墙机门卡数据类型
	selectCheck("enclosure_cardDataType",$("#enclosure_cardDataType_hv").val());
	
}




/**
 * 根据选中的围墙机型号 查询json文件给围墙机配置默认值
 * @param machineType
 */
function setEnclosureByJson(machineType){
	console.log("加载设备配置，围墙机设备型号："+machineType);
	var dataroot=ctx+"/static/json/enclosuretype.json?randID=" + Math.random();
	if(machineType==null || machineType=="" || machineType=="ZR60"){
		return;
	}
	$.getJSON(dataroot, function(data){ 
		var obj;
		for(i=0;i<data.length;i++){
			if(data[i].machineType==machineType){
				obj=data[i];
				break;
			}
		}
		
		radioCheck("enclosure_lockAuto",obj.lockAuto);
		radioCheck("enclosure_keyboard",obj.keyboard);
		radioCheck("enclosure_qcScanningFrame",obj.qcScanningFrame);
		radioCheck("enclosure_distanceswitch",obj.distance.open);
		radioCheck("enclosure_upPic",obj.upPic);
		
		setSelectOptions("enclosure_blackAndWhite",obj.talkVideo.blackAndWhite.options);
		setSelectOptions("enclosure_color",obj.talkVideo.color.options);
		setSelectOptions("enclosure_cardDataType",obj.cardDataType.options);
		
		selectCheck("enclosure_blackAndWhite",obj.talkVideo.blackAndWhite.select);
		selectCheck("enclosure_color",obj.talkVideo.color.select);
		selectCheck("enclosure_cardDataType",obj.cardDataType.select);
		selectCheck("enclosure_lockType",obj.lockType);
		
		$("[name=enclosure_low]").val(obj.adVolume.low);
		$("[name=enclosure_lowTime]").val(obj.adVolume.lowTime);
		$("[name=enclosure_high]").val(obj.adVolume.high);
		$("[name=enclosure_highTime]").val(obj.adVolume.highTime);
		$("[name=enclosure_lockDelayed]").val(obj.lockDelayed);
		$("[name=enclosure_callWait]").val(obj.callWait);
		$("[name=enclosure_talkVolume]").val(obj.talkVolume);
		$("[name=enclosure_tipsVolume]").val(obj.tipsVolume);
		$("[name=enclosure_lightCritical]").val(obj.lightCritical);
		$("[name=enclosure_centerIP]").val(obj.centerIP);
		$("[name=enclosure_cellIP]").val(obj.cellIP);
		$("[name=enclosure_distance]").val(obj.distance.distance);
        $("[name=enclosure_adSize]").val(obj.adSize);
		
	}); 
}


/**
 * 根据选中的门口机型号 查询json文件给门口机配置默认值
 * @param machineType
 */
function setDoorbellByJson(machineType){
	console.log("加载设备配置，门口机设备型号："+machineType);
	var dataroot=ctx+"/static/json/doorbelltype.json?randID=" + Math.random();
	if(machineType==null || machineType==""){
		return;
	}
	$.getJSON(dataroot, function(data){ 
		var obj;
		for(i=0;i<data.length;i++){
			if(data[i].machineType==machineType){
				obj=data[i];
				break;
			}
		}
		
		radioCheck("doorbell_lockAuto",obj.lockAuto);
		radioCheck("doorbell_keyboard",obj.keyboard);
		radioCheck("doorbell_qcScanningFrame",obj.qcScanningFrame);
		radioCheck("doorbell_distanceswitch",obj.distance.open);
		radioCheck("doorbell_upPic",obj.upPic);
		
		setSelectOptions("doorbell_blackAndWhite",obj.talkVideo.blackAndWhite.options);
		setSelectOptions("doorbell_color",obj.talkVideo.color.options);
		setSelectOptions("doorbell_cardDataType",obj.cardDataType.options);
		
		selectCheck("doorbell_blackAndWhite",obj.talkVideo.blackAndWhite.select);
		selectCheck("doorbell_color",obj.talkVideo.color.select);
		selectCheck("doorbell_cardDataType",obj.cardDataType.select);
		selectCheck("doorbell_lockType",obj.lockType);
		
		$("[name=doorbell_low]").val(obj.adVolume.low);
		$("[name=doorbell_lowTime]").val(obj.adVolume.lowTime);
		$("[name=doorbell_high]").val(obj.adVolume.high);
		$("[name=doorbell_highTime]").val(obj.adVolume.highTime);
		$("[name=doorbell_lockDelayed]").val(obj.lockDelayed);
		$("[name=doorbell_callWait]").val(obj.callWait);
		$("[name=doorbell_talkVolume]").val(obj.talkVolume);
		$("[name=doorbell_tipsVolume]").val(obj.tipsVolume);
		$("[name=doorbell_lightCritical]").val(obj.lightCritical);
		$("[name=doorbell_centerIP]").val(obj.centerIP);
		$("[name=doorbell_cellIP]").val(obj.cellIP);
		$("[name=doorbell_distance]").val(obj.distance.distance);
        $("[name=doorbell_adSize]").val(obj.adSize);
		
	}); 
}

/**
 * 根据设备型号 初始化设备视频分辨率对讲下拉框(门口机)
 * @param machineType
 */
function initDoorbellTalkVideo(machineType){
	var dataroot=ctx+"/static/json/doorbelltype.json?randID=" + Math.random();
	if(machineType==null || machineType==""){
		return;
	}
	$.getJSON(dataroot, function(data){ 
		var obj;
		for(i=0;i<data.length;i++){
			if(data[i].machineType==machineType){
				obj=data[i];
				break;
			}
		}	
		setSelectOptions("doorbell_blackAndWhite",obj.talkVideo.blackAndWhite.options);
		setSelectOptions("doorbell_color",obj.talkVideo.color.options);
		
	}); 
}
/**
 * 根据设备型号 初始化设备视频分辨率对讲下拉框(围墙机)
 * @param machineType
 */
function initEnclosureTalkVideo(machineType){
	var dataroot=ctx+"/static/json/enclosuretype.json?randID=" + Math.random();
	if(machineType==null || machineType==""){
		return;
	}
	$.getJSON(dataroot, function(data){ 
		var obj;
		for(i=0;i<data.length;i++){
			if(data[i].machineType==machineType){
				obj=data[i];
				break;
			}
		}	
		setSelectOptions("enclosure_blackAndWhite",obj.talkVideo.blackAndWhite.options);
		setSelectOptions("enclosure_color",obj.talkVideo.color.options);
		
	}); 
}
/**
 * 设置下拉框的选项
 * @param selectId
 * @param options
 */
function setSelectOptions(selectId,options){
	var optionshtml='';
	for(i=0;i<options.length;i++){
		optionshtml+='<option value="'+options[i]+'">'+options[i]+'</option>';
	}
	$("#"+selectId).html(optionshtml);
}



/**
 * 选中下拉框的值
 * @param selectId
 * @param value
 */
function selectCheck(selectId,value){
	$("#"+selectId).children("option").each(function(){
		if($(this).val()==value){
			this.selected=true;
		}
	});
}
/**
 * 选中单选框的值
 * @param radioName
 * @param value
 */
function radioCheck(radioName,value){
	if(value=="true"){
		$('input[name$='+radioName+']:eq(0)').attr("checked","checked");
	}else{
		$('input[name$='+radioName+']:eq(1)').attr("checked","checked");
	}
}


/**
 * 物业后台对小区功能配置和设备配置信息 只读
 */
function setReadOnly(){
	$("#div-services select").attr("disabled","disabled");
	
	$("#div-doorbellconfigure input").attr("readonly","readonly");
	$("#div-doorbellconfigure select").attr("disabled","disabled");
	$("#div-doorbellconfigure input:radio").attr("disabled","disabled");
	$("[name=doorbell_lowTime]").removeAttr("onclick");
	$("[name=doorbell_highTime]").removeAttr("onclick");
	
	$("#div-enclosureconfigure input").attr("readonly","readonly");
	$("#div-enclosureconfigure select").attr("disabled","disabled");
	$("#div-enclosureconfigure input:radio").attr("disabled","disabled");
	$("[name=enclosure_lowTime]").removeAttr("onclick");
	$("[name=enclosure_highTime]").removeAttr("onclick");
}