/**
 * 小区回填列表
 */

$(function(){	
	/*绑定全选事件*/
	var binding = new SelectAll();
	binding.bindingSelectAll('popCell2ListTableDiv');	
	/**
	 * 获取查询条件
	 */
	function getSearchTerm(){
		var data = cellList2.data;
		//data.communityId = $("form.form-search :input[name=communityId]").val();
		data.cellName = $('#cellBackfillQueryTerm :input[name=cellName]').val();
		console.log(JSON.stringify(data));
		return data;
	}
	//实现回填列表数据搜索
	$('div span.btn_search').click(function(){
		var data = getSearchTerm();
		data.page=1;
		getPopTablePageData(data);
	});
	
	//实现分页条件查询
	console.log('popCell2ListTableDiv');
	$('#popCell2ListTableDiv div.my-pagination > div > a').click(function(){
		var data = getSearchTerm();
		var href = $(this).attr('href');
		//截取href中#之后的值
		var str = href.substring(1,href.Length);
		data.page=parseInt(str);
		getPopTablePageData(data);
	});
	$('#popCell2ListTableDiv div.my-pagination .page-current').change(function(){
		var data = getSearchTerm();
		var page = $(this).val();
		data.page=parseInt(page);
		getPopTablePageData(data);
	});
	adjustTableCellWidth('popCell2ListTableDiv');
});

function getPopTablePageData(data){
	doDataPost(data, false, ctx+"/common/cell/backfill2", function(msg){
		$($('.layui-layer-content')[0]).empty();
		$($('.layui-layer-content')[0]).append(msg);
		layer.iframeAuto(cellList2.indexLayer);
		checkedboxInpage(cellIds);
	});
}

/***********************************checkbox相关内容开始***************************************/

var backfillcheckbox=$("table.cell_backfill2").find(':input[type=checkbox]');
//点击小区全选按钮 
$('#popCheckbox').click(function(){
	console.log('popCheckbox');
	var hasNoChecked = false; //是否有没有选择上的
	for(var i=0; i<backfillcheckbox.length; i++){
		if(!backfillcheckbox[i].checked){
			hasNoChecked = true;
			break;
		}
	}
	
	backfillcheckbox.each(function () {
		if(hasNoChecked){
	        if(!this.checked){//把所有未选中的全部选中，并触发change
	        	 this.checked = "checked"; 
	        	 $(this).change();
	        }
		}else{
			this.checked = !this.checked;
	        $(this).change();
		}
     });
});

//点击小区选择确定按钮 
$('#btn_commSelected').click(function(){
	var data = {};
	data.cellIds = cellIds;
	data.cellNames = cellNames;
	//alert('xyz:'+JSON.stringify(data));
	cellList2.backfillFun(data);
	layer.closeAll();
});

//监听小区复选框选中状态
backfillcheckbox.change(function(){
	var cellid=$(this).val();
	var cellName=$(this).parents("tr").children("td").eq(1).html();
	//先删除一次 避免重复添加到数组
//	cellIds.remove(cellid);
//	cellNames.remove(cellName);
	var removeflag=cellIds.remove(cellid);
	if(removeflag==1){
		cellNames.remove(cellName);
	}
	//如果选中，添加到数组
	if(this.checked){
		cellIds.push(cellid);
		cellNames.push(cellName);
	} 
	$("#selectedComms").val(cellNames);
});

//检查默认选中该页已经勾选过的复选框。适用于翻页情况
function checkedboxInpage(){
	$("#selectedComms").val(cellNames);
	backfillcheckbox.each(function () {
		for (var i = 0; i < cellIds.length; i++) {
			if (cellIds[i] == $(this).val())  
				this.checked = "checked";
		}
     });
}
//为回调函数赋值
cellList2.callback = function(data){
	var checkedIds = data.checkedIds;
	var checkboxs = $("table.cell_backfill2").find(':input[type=checkbox]');
	$(checkboxs).each(function(){
		if(isChecked(this.value,checkedIds)){			
			$(this).attr("checked","checked");	
			$(this).change();
		}
	});
}
//获取数组元素下标
Array.prototype.indexOf = function(val) {
	for (var i = 0; i < this.length; i++) {
		if (this[i] == val) return i;
	}
	return -1;
};
//移除数组元素
Array.prototype.remove = function(val) {
	var index = this.indexOf(val);
	if (index > -1){
		this.splice(index, 1);
		return 1;
	}else{
		return 0;
	}
		
};

function isChecked(v,ids){	
	if(typeof(v) == "undefined"){
		return false;
	}else if(typeof(ids) == "undefined"){
		return false;
	}
	for(var i=0,a;a=ids[i++];){		
	  if(v == a){
		  return true;
	  }
	}
	return false;
}
