/**
 * 房间回填列表
 */

$(function(){
	//实现回填列表数据搜索
	$('div span.btn_search').click(function(){
		var data = getSearchTerm();
		data.page=1;
		getPopTablePageData(data);
	});
	
	/**
	 * 搜索文本框支持回车
	 * 阻止提交表单
	 */
	$("form.form-search").submit(function(){		  
		  return false;
	}).find(":input[name=cell_name]").keydown(function(){		
		if(event.keyCode == 13) {
			var data = getSearchTerm();
			data.page=1;
			getPopTablePageData(data);		
		}
	});
	
	
	
	//实现分页条件查询
	console.log('popCellListTableDiv');
	$('#popCellListTableDiv div.my-pagination > div > a').click(function(){
		var data = getSearchTerm();
		var href = $(this).attr('href');
		//截取href中#之后的值
		var str = href.substring(1,href.Length);
		data.page=parseInt(str);
		getPopTablePageData(data);
	});
	$('#popCellListTableDiv div.my-pagination .page-current').change(function(){
		var data = getSearchTerm();
		var page = $(this).val();
		data.page=parseInt(page);
		getPopTablePageData(data);
	});
	adjustTableCellWidth('popCellListTableDiv');
	
	//获取回填数据
	$('table > tbody > tr input[type=radio]').parents("tr").click(function(){
		var data = {};
		data.id = $(this).find(':input[type=radio]').val();
		data.name = $(this).find('td:eq(2)').html();
		//alert(JSON.stringify(data));
		cellList.backfillFun(data);
		layer.closeAll();
	});
});

function getPopTablePageData(data){
	doDataPost(data, false, ctx+"/common/cell/backfill", function(msg){
		$($('.layui-layer-content')[0]).empty();
		$($('.layui-layer-content')[0]).append(msg);
		layer.iframeAuto(indexLayer);
	});
}

/**
 * 获取查询条件
 */
function getSearchTerm(){
	var data = {};
	data.buildId = $('.layui-layer form.form-search #b_buildId').val();	
	data.communityId = $('.layui-layer form.form-search :input[type=hidden][name$=communityId]').val();
	data.name = $('.layui-layer form.form-search :input[name=cell_name]').val();
	data.noMaster = $('.layui-layer form.form-search :input[type=hidden][name$=noMaster]').val();
	return data;
}
