var mobileClickTimes = 0;
var tr_index = -1;

$(function () {
    //当前小区input填入值
    $('#search_communityName').val($('#currentManageCommunityName').val());

    /**
     * 打开楼栋回填列表
     */
    $('#search_buildName').click(function () {
        var currentManageCommunityId = $('#currentManageCommunityId').val();
        if (currentManageCommunityId == null || currentManageCommunityId.length <= 0) {
            alert("请先选择当前管理小区");
            return;
        }
        var data = {"communityId": currentManageCommunityId};
        buildList.data = data;
        buildList.popBuildList(data);
        buildList.backfillFun = function (data) {
            $('#search_buildId').val(data.id);
            $('#currentManageBuildId').val(data.id);
            $('#search_buildName').val(data.name);
            $('#search_buildId').change();
            $('.btn_search_more').trigger('click');
        }
    });

    //第一次进入自动弹出 选择楼栋
    // if($('#cell_firstIn').val()==1) {
    //     $('#search_buildName').trigger('click');
    // }

    /**
     * 搜索文本框支持回车
     * 阻止提交表单
     */
    $("form.form-search").submit(function () {
        return false;
    }).find(":input[name=search]").keydown(function () {
        if (event.keyCode == 13) {
            refreshList();
        }
    });

    /**
     * 点击搜索按钮
     */
    $('.btn_search_more').click(function () {
        refreshList();
    });

    /**
     * 实现分页条件查询
     */
    $('#cellListTableDiv div.my-pagination > div > a').click(function () {
        var data = getSearchTerm();
        var href = $(this).attr('href');
        //截取href中#之后的值
        var str = href.substring(1, href.length);
        data.page = parseInt(str);
        getPageData(data, ctx + "/adm/cell/list");
    });

    $('#cellListTableDiv div.my-pagination .page-current').change(function () {
        var data = getSearchTerm();
        var page = $(this).val();
        data.page = parseInt(page);
        getPageData(data, ctx + "/adm/cell/list");
    });

    adjustTableCellWidth('cellListTableDiv');

    /**
     * 点击表格上添加按钮
     */
    $('#add_btn').click(function () {
        var data = {};
        doDataPost(data, false, ctx + "/adm/cell/add/form_ui", function (htmlText) {
            $("div.popup_window").remove();
            addForm(htmlText);
            openWin('cell_add_div');
        });
    });

    /**
     * 点击表格上删除按钮
     */
    $('#remove_btn').click(function () {
        var currentBuildId = $('#currentManageBuildId').val();
        if (currentBuildId == null || currentBuildId.length <= 0) {
            alert("请先选择当前楼栋");
            return;
        }
        var x = ($(window).width() - 260 + $('div.viewFramework-sidebar').width()) / 2;
        var y = ($(window).height() / 2 - 73);
        var flag = false;
        $('table > tbody > tr > td > input[type=checkbox]').each(function () {
            var input = $(this);
            if (input.is(':checked')) {
                flag = true;
            }
        });
        if (!flag) {
            layer.alert('请选择要删除的房间。', {
                icon: 0,
                title: '提示',
                area: ['260px', '146px'],
                offset: [y + 'px', x + 'px']
            });
            return;
        }
        layer.confirm('确定要删除？', {
            icon: 3,
            title: '提示',
            btn: ['确定', '取消'],
            area: ['260px', '146px'],
            offset: [y + 'px', x + 'px']
        }, function (index) {
            // remove(ctx + "/adm/cell/del");
            removeAndRefreshOfCell(currentBuildId,ctx + "/adm/cell/del",function () {
                refreshList();
            });
            layer.close(index);
        });
    });

    /**
     * 双击表格弹出修改窗口
     */
    $('table > tbody > tr').click(function () {
        var this_index = $(this).index();
        if (this_index == tr_index) {
            if (mobileClickTimes > 0) {
                dblclickF(this);
                mobileClickTimes = 0;
                tr_index = -1;
            }
        } else {
            tr_index = this_index;
            setTimeout(function () {
                mobileClickTimes = 0;
                tr_index = -1;
            }, 400);
        }
        mobileClickTimes++;
    });

    function dblclickF(obj) {
        var id = $(obj).find(':checkbox:eq(0)').val();
        var data = {};
        data['id'] = id;
        doDataPost(data, false, ctx + "/adm/cell/edit/form_ui", function (htmlText) {
            $("div.popup_window").remove();
            addForm(htmlText);
            openWin('cell_edit_div');
        });
    }

});

function removeAndRefreshOfCell(buildId,url,callback){
    var ids = [];
    var data={};
    data.buildId = buildId;
    $('table > tbody > tr > td > input[type=checkbox]').each(function(){
        var input = $(this);
        if(input.is(':checked')){
            ids.push(input.val());
        }
    });
    $('table > tbody > tr > td > input[type=radio]').each(function(){
        var input = $(this);
        if(input.is(':checked')){
            ids.push(input.val());
        }
    });
    data.ids=ids.join(',');
    doDataPost(data, false, url, function(json){
        var msgJson = isJsonObject(json);
        if(msgJson == false){
            //     closeWin("news_check_div");
            $("#work_area").append(json);
        }else if(typeof(json)=='string'){
            var json = $.parseJSON(json);
            openTipLayer(json.msg);
            if (json.code == '0') {
                //需要重新查询
                if(callback) callback();
            }
        }else{
            if (json.code == '0') {
                openTipLayer(json.msg);
                //需要重新查询
                if(callback) callback();
            } else {
                myAlert(json.msg);
            }
        }

    });
}

/**
 * 刷新列表页面（附搜索条件）
 */
function refreshList() {
    var data = getSearchTerm();
    doDataPost(data, false, ctx + "/adm/cell/list", function (msg) {
        addPage(msg);
    });
}

/**
 * 获取请求数据
 */
function getSearchTerm() {
    var data = {};
    data.search_communityId = $('form.form-search input[name$=search_communityId][type=hidden]').val();
    data.search_communityName = $('form.form-search input[name$=search_communityName]').val();
    data.search_buildName = $('form.form-search input[name$=search_buildName]').val();
    data.search_buildId = $('form.form-search input[name$=search_buildId]').val();
    data.search_cellName = $('form.form-search input[name=search_cellName]').val();
    return data;
}