/**
 * 添加bootstrapValidator校验
 */
$(function() {
	$("form[name=cell_add_from]").bootstrapValidator({
		message : 'This value is not valid',
		excluded : [ ':disabled' ],
		feedbackIcons : {
			valid : 'glyphicon glyphicon-ok',
			invalid : 'glyphicon glyphicon-remove',
			validating : 'glyphicon glyphicon-refresh'
		},
		fields : {
			'communityName' : {
				validators : {
					notEmpty : {
						message : '小区不能为空'
					}
				}
			},
			'buildName' : {
				validators : {
					notEmpty : {
						message : '楼栋不能为空'
					}
				}
			},
			'num':{
				validators:{
					notEmpty:{
						message : '门牌不能为空'
					},
	                regexp: {
	                    regexp: /^\d{4}$/i,
	                    message: '门牌只能为四位数字'
	                }
				}
			},
			'callphone':{
				validators:{
					regexp: {

	                    regexp:/(^(0\d{2,3})?-?[1-9]\d{6,7}$)|(^(\d{2})?1[3-9]\d{9}$)|(^([5|6|8|9])\d{7}$)/,
	                    message: '请输入正确的呼叫号码'
	                }
				}
			},
			'address':{
				validators:{
					notEmpty:{
						message : '地址不能为空'
					},
					regexp: {
                        regexp: getUtfRegexp(),
                        message: '含有非法字符'
                    }
				}
			},
			'name':{
				validators:{
					notEmpty:{
						message : '房间名不能为空'
					},
					regexp: {
                        regexp: getUtfRegexp(),
                        message: '含有非法字符'
                    }
				}
			}
		}
	});
});

$(function(){
	/**
	 * 点击关闭按钮，关闭当前弹出窗口
	 */
	$('#btn_cancel').click(function(){
		closeWin('cell_add_div');
	});
	/**
	 * 点击表单ok按钮
	 */
	$('#btn_ok').click(function(){
		$("form[name=cell_add_from]").bootstrapValidator('validate');
		var valid = $("form[name=cell_add_from]").data('bootstrapValidator').isValid();
		if(!valid){
			return;
		}
		doFormPost("cell_add_from",ctx+"/adm/cell/add",function(json){
			//var json=$.parseJSON(repJson);
			openTipLayer(json.msg);
			if(json.code==0){
				refreshList();
				closeWin('cell_add_div');
			}

		});

	});

	/*打开楼栋回填列表*/
	$('#buildName').click(function(){
		var communityId=$('form[name=cell_add_from] input[type=hidden][name$=communityId]').val();
		if(communityId==null || communityId.length<=0){
			alert("请先选择小区");
			return;
		}
		var data={"communityId":communityId};
		buildList.data=data;
		buildList.popBuildList(data);

		//回填表单对应的数据域,该函数需要回调者进行实现
		buildList.backfillFun = function (data){
			$('#buildId').val(data.id);
			$('#buildName').val(data.name);
			revalidate('buildName');
			autocompleteAdr(data.id);
		}
	});
	/**
	 * 当hidden域name=communityId的input控件value发生变化时
	 */
	$('form[name=cell_add_from] input[type=hidden][name$=communityId]').on('change',function(){

		$('#buildId').val("");
		$('#buildName').val("");
		$("form[name=cell_add_from] :input[name$=address]").val("");
		$("form[name=cell_add_from] :input[name$=name]").val("");
		revalidate('buildName');
		revalidate('address');
		revalidate('name');
	});

	/**
	 * 根据楼栋ID补全房间地址
	 */
	function autocompleteAdr(builId){
        if(builId == null || builId.length<=0){
            return;
        }
		var data = {};
		data.buildId = builId;
		doDataPost(data,false,ctx+"/adm/build/model/data",function(json){
			//var json=$.parseJSON(repJson);
			var adr = json.data.address;
			var buildName =  json.data.name;
			var cellNum = $("form[name=cell_add_from] :input[name$=num]").val();
			$('form[name=cell_add_from] :input[name$=address]').val(adr);
			autocompleteName(buildName,cellNum);
		});
	}

	$("form[name=cell_add_from] :input[name$=num]").on('keyup',function(){
		var num = $(this).val();
		var buildName = $('#buildName').val();
		autocompleteName(buildName,num);
	});
	/**
	 * 根据楼栋名称+房间编号回填房间名
	 */
	function autocompleteName(buildName,cellNum){
		if(buildName=="请选择楼栋"){
			buildName="";
		}
		var cellName = buildName+"-"+cellNum;
		$('form[name=cell_add_from] :input[name$=name]').val(cellName);
		revalidate('name');
		revalidate('address');
	}
	/**
	 * 需要重新验证数据
	 */
	function revalidate(field){
		//程序回填域需要调用如下函数通知bootstrapValidator校验框架
		$('form[name=cell_add_from]').data('bootstrapValidator')
	     .updateStatus(field, 'NOT_VALIDATED', null)
	     .validateField(field);
	}

    /**
     * 判断所选是否是上海智能安防小区
     */
    function checkShanghaiSmartSecurity() {
        var communityId=$('#communityId').val();
        if(communityId==null || communityId.length<=0){
            alert("请先选择小区");
            return;
        }
        var data = {"communityId":communityId};
        $.ajax({
            type:"POST",
            url:ctx +"community/checkShSmartSecurity",
            data:data,
            success:function(json){
                //是否是 上海智能安防小区的标志
                var flag = json.data;
                showShanghaiCellCode(flag);
            }
        });
    }

    /**
     * 上海智能安防房间编号
     */
    function showShanghaiCellCode(flag){
        //显示
        if(flag==1) {
            $("#smark_security_code_div").css("display", "block");
            //添加验证
            $("form[name=cell_add_from]").data('bootstrapValidator').enableFieldValidators('smartCellCode',true);
            revalidate('smartCellCode');
        }
        //隐藏
        else if(flag==0) {
            $("#smark_security_code_div").css("display", "none");
            //取消验证
            $("form[name=cell_add_from]").data('bootstrapValidator').enableFieldValidators('smartCellCode',false);
            // $("form[name=cell_add_from]").bootstrapValidator('removeField','smartCellCode');
            revalidate('smartCellCode');
        }
    }
});