//@ sourceURL=buildEdit.js
/**
 * 添加bootstrapValidator校验
 */
$(function () {
    $("form[name=build_edit_from]").bootstrapValidator({
        message: 'This value is not valid',
        excluded: [':disabled'],
        feedbackIcons: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        fields: {
            'communityName': {
                validators: {
                    notEmpty: {
                        message: '小区不能为空'
                    }
                }
            },
            'name': {
                validators: {
                    notEmpty: {
                        message: '楼栋名称不能为空'
                    },
                    regexp: {
                        regexp: getUtfRegexp(),
                        message: '含有非法字符'
                    }
                }

            },
            'num': {
                validators: {
                    notEmpty: {
                        message: '楼栋编号不能为空'
                    },
                    regexp: {
                        regexp: /^\d{4}$/i,
                        message: '楼栋编号只能为四位数字'
                    }
                }

            }/*,
			'longitude':{
				validators : {
					notEmpty : {
						message : '经度不能为空'
					},				
	                regexp: {
	                    regexp: /^(([0-9]+\d*)|([0-9]+\d*\.\d{1,6}))$/,                    
	                    message: '纬度格式不正确'
	                }
				}				
			},
			'latitude':{
				validators : {
					notEmpty : {
						message : '纬度不能为空'
					},				
	                regexp: {
	                    regexp: /^(([0-9]+\d*)|([0-9]+\d*\.\d{1,6}))$/,                    
	                    message: '纬度格式不正确'
	                }
				}				
			}*/,
            'address': {
                validators: {
                    notEmpty: {
                        message: '地址不能为空'
                    },
                    regexp: {
                        regexp: getUtfRegexp(),
                        message: '含有非法字符'
                    }
                }
            }

        }
    });
});

$(function () {
    //点击关闭按钮，关闭当前弹出窗口
    $('#btn_cancel').click(function () {
        closeWin("build_edit_div");
    });
    //点击表单ok按钮
    $('#btn_ok').click(function () {
        //表单数据格式合法性验证
        $("form[name=build_edit_from]").bootstrapValidator('validate');
        var valid = $("form[name=build_edit_from]").data('bootstrapValidator').isValid();
        if (!valid) {
            return;
        }
        doFormPost("build_edit_from", ctx + "/adm/build/upd", function (json) {
            if (isOK(json)) {
                //var json=$.parseJSON(repJson);
                openTipLayer(json.msg);
                if (json.code == 0) {
                    refreshList();
                    closeWin("build_edit_div");
                }

            }
        });

    });


    /**
     * 监听小区下拉框选择事件
     */
    $("form[name=build_edit_from] :input[type=hidden][name$=communityId]").on('change', function () {
        autoBuildName();
        revalidate('name');

        //定位小区地址
        var data = {};
        data.id = $(this).val();
        doDataPost(data, false, ctx + "/common/community/getAddressById", function (json) {
            if (json.code == 0 && json.msg != null && json.msg != "") {
                var address = json.msg;
                $("#build_address").val(address);
                $("#build_address").change();

            }

        });
    });

    $("#num").on('keyup', function () {
        autoBuildName();
        revalidate('name');
    });
    $("#build_address").change(function () {
        revalidate('address');
    });
    // $("#build_longitude").change(function(){
    // 	revalidate('longitude');
    // });
    // $("#build_latitude").change(function(){
    // 	revalidate('latitude');
    // });
});

/**
 * 门的操作
 * */
$(function () {
    /**
     * 获取滚动pane
     */
    var pane = $('#scrollDiv');
    pane.jScrollPane(
        {
            animateScroll: true
        }
    );
    var api = pane.data('jsp');

    // 监听添加门信息的事件，打开添加表单页面
    $("#add_door_btn").click(function () {
        var data = {};
        var buildId = $("#buildId").val();
        var buildName = $("#buildName").val();
        data.buildId = buildId;
        data.buildName = buildName;
        doDataPost(data, false, ctx + "/adm/door/add/form_ui", function (htmlText) {
            $("div.popup_window").remove();
            addForm(htmlText);
            openWin('door_add_div');
        });
    });
})

/**
 * 自动生成楼栋名
 */
function autoBuildName() {
    var communityName = $('form[name=build_edit_from] :input[name$=communityName]').val();
    var buildNum = $("#num").val();
    var buildName = "";
    if (buildNum == null || buildNum == "") {
        buildName = communityName;
    } else {
        buildName = communityName + "-" + buildNum + "栋";
    }
    $('#buildName').val(buildName);

}

/**
 * 需要重新验证数据
 */
function revalidate(field) {
    //程序回填域需要调用如下函数通知bootstrapValidator校验框架
    $('form[name=build_edit_from]').data('bootstrapValidator')
        .updateStatus(field, 'NOT_VALIDATED', null)
        .validateField(field);
}