/**
 * 添加bootstrapValidator校验
 */
$(function() {
	// 封装小区名称和id
	$("#currentBuildOfCommunityName").val($("#currentManageCommunityName").val());
	$("#currentBuildOfCommunityId").val($("#currentManageCommunityId").val());

	$("form[name=build_add_from]").bootstrapValidator({
		message : 'This value is not valid',
		excluded : [ ':disabled' ],
		feedbackIcons : {
			valid : 'glyphicon glyphicon-ok',
			invalid : 'glyphicon glyphicon-remove',
			validating : 'glyphicon glyphicon-refresh'
		},
		fields : {
			'communityName' : {
				validators : {
					notEmpty : {
						message : '小区不能为空'
					}
				}
			},
			'name':{
				validators : {
					notEmpty : {
						message : '楼栋名称不能为空'
					}, 
					regexp: {
                        regexp: getUtfRegexp(),
                        message: '含有非法字符'
                    }
				}
				
			}/*,
			'longitude':{
				validators : {
					notEmpty : {
						message : '经度不能为空'
					},				
	                regexp: {
	                    regexp: /^(([0-9]+\d*)|([0-9]+\d*\.\d{1,6}))$/,                    
	                    message: '经度格式不正确'
	                }
				}
				
			},
			'latitude':{
				validators : {
					notEmpty : {
						message : '纬度不能为空'
					},				
	                regexp: {
	                    regexp: /^(([0-9]+\d*)|([0-9]+\d*\.\d{1,6}))$/,                    
	                    message: '纬度格式不正确'
	                }
				}
				
			}*/,
			'num':{
				validators : {
					notEmpty : {
						message : '楼栋编号不能为空'
					},				
	                regexp: {
	                    regexp: /^\d{4}$/i,                    
	                    message: '楼栋编号只能为四位数字'
	                }
				}
				
			},
			'address':{
				validators : {
					notEmpty:{
						message : '地址不能为空'
					}, 
					regexp: {
	                    regexp: getUtfRegexp(),
	                    message: '含有非法字符'
	                }
				}
			}
		
		}
	});
});

$(function(){
	//点击表单ok按钮
	$('#btn_ok').click(function(){
		//表单数据格式合法性验证
		$("form[name=build_add_from]").bootstrapValidator('validate');
		var valid = $("form[name=build_add_from]").data('bootstrapValidator').isValid();
		if(!valid){
			return;
		}	
		doFormPost("build_add_from",ctx+"/adm/build/add",function(json){
			if(isOK(json)){
				//var json=$.parseJSON(repJson);
				openTipLayer(json.msg);
				if(json.code==0){
					refreshList();
					closeWin("build_add_div");
				}
				
			}
		});
		
	});
	//点击关闭按钮，关闭当前弹出窗口
	$('#btn_cancel').click(function(){
		closeWin("build_add_div");
	});
	
	/*打开小区回填列表*/
	$('form[name=build_add_from] :input.form-select[name$=communityName]').click(function(){
		//回填表单对应的数据域,该函数需要回调者进行实现
		communityList.backfillFun = function (data){
			$('form[name=build_add_from] :input[type=hidden][name$=communityId]').val(data.id);
			$('form[name=build_add_from] :input[name$=communityName]').val(data.name);
			//需要收工触发onchange事件
			$('form[name=build_add_from] :input[type=hidden][name$=communityId]').change();
			revalidate('communityName');
		}
		var adminId=$("#adminId").val();
		var data={"adminId":adminId};
		communityList.data=data;
		communityList.popCommunityList(data);
	});
	/**
	 * 监听小区下拉框选择事件
	 */
	$("form[name=build_add_from] :input[type=hidden][name$=communityId]").on('change',function(){
		autoBuildName();
		revalidate('name');
		//定位小区地址
        var data = {};
        data.id=$(this).val();
        doDataPost(data,false,ctx+"/common/community/getAddressById",function(json){
            if(json.code==0 && json.msg!=null && json.msg!=""){
                var address=json.msg;
                $("#build_address").val(address);
                $("#build_address").change();

            }

        });
	});
	
	$("#num").on('keyup',function(){	
		autoBuildName();
		revalidate('name');
	});	
	
	$("#build_address").change(function(){
		revalidate('address');
	});
	// $("#build_longitude").change(function(){
	// 	revalidate('longitude');
	// });
	// $("#build_latitude").change(function(){
	// 	revalidate('latitude');
	// });
	
});

/**
 * 自动生成楼栋名
 */
function autoBuildName(){
	var communityName=$('form[name=build_add_from] :input[name$=communityName]').val();
	var buildNum=$("#num").val();
	var buildName ="";
	if(buildNum==null || buildNum==""){
		buildName=communityName;
	}else{
		buildName = communityName+"-"+buildNum+"栋";
	}
	$('#buildName').val(buildName);
	
}

/**
 * 需要重新验证数据
 */
function revalidate(field){
	//程序回填域需要调用如下函数通知bootstrapValidator校验框架
	$('form[name=build_add_from]').data('bootstrapValidator')
     .updateStatus(field, 'NOT_VALIDATED', null)
     .validateField(field); 
}