package com.zzwtec.wechat.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {

    // yyyy-MM-dd HH:mm:ss
    private static final String NOW_TIME_1 = "yyyy-MM-dd HH:mm:ss";

    // yyyyMMddHHmmss
    private static final String NOW_TIME_2 = "yyyyMMddHHmmss";

    // yyyyMM
    private static final String THIS_MONTH_TIME = "yyyyMM";

    // M月d日 HH:mm:ss
    private static final String WX_NOW_TIME = "M月d日 HH:mm:ss";


    public static String format(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    /**
     * 获取当前时间
     *
     * @return 返回当前时间格式为yyyyMMddHHmmss的long型，如20151231235900
     */
    public static long getNowTime() {
        return Long.parseLong(format(NOW_TIME_2, new Date()));
    }

    /**
     * 获取几个月前时间
     *
     * @param mouth 几个月前 主要是负数 如一个月前 则为-1
     * @return 返回当前时间格式为yyyyMMddHHmmss的long型，如20151231235900
     */
    public static long getSomeMonthsAgoTime(int mouth) {
        Date dNow = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dNow);
        calendar.add(Calendar.MONTH, mouth);
        return Long.parseLong(format(NOW_TIME_2, calendar.getTime()));
    }

    /**
     * 获取当月时间
     *
     * @return 返回当前时间格式为yyyyMMddHHmmss的long型，如当天是2017年6月13日11点55分10秒，返回20170600000000
     */
    public static long getThisMonthsTime() {
        long thisMonthsTime = Long.parseLong(format(THIS_MONTH_TIME, new Date()));
        thisMonthsTime *= 100000000l;
        return thisMonthsTime;
    }

    /**
     * 获取当前时间
     *
     * @return 返回当前时间格式为M月d日 HH:mm:ss，如5月11日 18:00:00
     */
    public static String getWxNowTime() {
        return format(WX_NOW_TIME, new Date());
    }

    /**
     * 获取将yyyyMMddHHmmss的long型转为M月d日 HH:mm:ss，如5月11日 18:00:00
     */
    public static String getWxTime(long time) {
        String timeStr = timeLong2Str(time);
        timeStr = timeStr.substring(5).replace("-", "月").replace(" ", "日 ");
        if (timeStr.startsWith("0")) {
            timeStr = timeStr.substring(1);
        }
        timeStr = timeStr.replace("月0", "月");
        return timeStr;
    }

    /**
     * 时间转换 将long转为字符串 即将 "20151231235900" 转为 "2015-12-31 23:59:00"
     *
     * @param time
     * @return
     */
    public static String timeLong2Str(long time) {
        String timeStr = String.valueOf(time);
        StringBuilder reSB = new StringBuilder();
        for (int i = 0; i < timeStr.length(); i++) {
            reSB.append(timeStr.charAt(i));
            if (i == 3 || i == 5) {
                reSB.append("-");
            }
            if (i == 7) {
                reSB.append(" ");
            }
            if (i == 9 || i == 11) {
                reSB.append(":");
            }
        }
        timeStr = reSB.toString();
        reSB = null;
        return timeStr;
    }

    /**
     * 时间转换 将字符串转为long 即将 "2015-12-31 23:59:00" 转为 "20151231235900"
     *
     * @return
     */
    public static long timeStr2Long(String timeStr) {
        if (timeStr == null || timeStr.length() == 0) {
            return 0;
        }
        timeStr = timeStr.replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "");
        long time = Long.parseLong(timeStr);
        return time;
    }

    /**
     * 检测时间是否符合要求
     *
     * @param time 时间格式是yyyy-MM-dd HH:mm:ss
     * @return
     */
    public static boolean checkTimeStr(String time) {
        return CharUtil.characterDetection(time, CharUtil.TIME_LSDF_MATCH);
    }

    /**
     * 检测时间是否符合要求
     *
     * @param time 时间格式是yyyyMMddHHmmss
     * @return
     */
    public static boolean checkTimeData(String time) {
        return CharUtil.characterDetection(time, CharUtil.TIME_NOWTIMEDF_MATCH);
    }
}
