package com.zzwtec.wechat.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zzwtec.third.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.UUID;


public class CommonUtil {
	private static final Logger logger = LoggerFactory.getLogger(CommonUtil.class);
    //web请求操作码前缀
	//public static final String WEB_REQUESTID_PREFIX = "web";

	public static final String USER_TOKEN_PREFIX = "user-";
	public static final String DEVICE_TOKEN_PREFIX = "device-";
	public static final String DEVICE_IPC_TOKEN_PREFIX = "device-ipc-";
	public static final String SYSUSER_TOKEN_PREFIX = "sysuser-";
	public static final String ADUSER_TOKEN_PREFIX = "aduser-";
	public static final String ZR60_LOCK_STATE = "zr60-lock-state-";
	public static final String ZR60_CARD_LIST = "zr60-card-list-";
	//慧联临时密码前缀
	public static final String HL_TEMP_PSW_PREFIX="hl-tmp-psw-";
	// 慧联方面的设备状态
	public static final String HL_STATUS_PREFIX = "hl-state-";

	//总后台角色ID前缀
	public static final String ACCOUNT_ROLE_PREFIX = "account_role";
	//物业后台角色ID前缀
	public static final String ADMIN_ROLE_PREFIX = "admin_role";
	//总后台管理员ID前缀
	public static final String ACCOUNT_PREFIX = "account";
	//物业后台管理员ID前缀
	public static final String ADMIN_PREFIX = "admin";
	//总后台管理员ID前缀
	public static final String BIGDATAUSER_PREFIX = "cmpadmin";
	
	//百度语音Token的redis缓存key
	public static final String VOICE_TOKEN_CACHE = "VOICE_TOKEN:";
	
	//验证码的redis前缀
	public static final String VERIFY_CODE_PREFIX = "VERIFY_CODE:";

	// 开锁日志的redis缓存前缀
	public static final String OPEN_DOOR_LOG_PREFIX = "OPEN_DOOR_LOG:";

	// 用户房产id的redis缓存前缀
	public static final String CELL_ID_LIST_PREFIX = "CELL_ID_LIST:";

	// 地图坐标数据
	public static final JSONObject GEO_MAP = JSON.parseObject("{\"461\":[100.9,36.97],\"427\":[99.7,27.83],\"494\":[120.67,24.15],\"7\":[112.56,37.87],\"8\":[111.747,40.8],\"9\":[123.429,41.83],\"433\":[80.1,32.5],\"400\":[102.22,31.9],\"425\":[98.58,24.43],\"3\":[121.47,31.23],\"10\":[126.55,43.83],\"477\":[82.07,44.9],\"186\":[129.5,42.88],\"6\":[116.4,39],\"23\":[110.34,20.01],\"500\":[120.8,24.53],\"501\":[120.72,24.25],\"502\":[120.53,24.08],\"503\":[120.67,23.92],\"504\":[120.53,23.72],\"506\":[120.32,23.32],\"507\":[120.37,22.63],\"508\":[120.48,22.67],\"509\":[121.75,24.77],\"510\":[121.6,23.98],\"511\":[121.15,22.75],\"512\":[119.58,23.58],\"4\":[117.2,39.12],\"497\":[121.5,25.03],\"457\":[103.22,35.6],\"403\":[106.63,26.65],\"404\":[104.83,26.6],\"405\":[106.92,27.73],\"406\":[105.95,26.25],\"407\":[109.18,27.72],\"483\":[81.32,43.92],\"409\":[105.28,27.3],\"412\":[102.72,25.05],\"413\":[103.8,25.5],\"414\":[102.55,24.35],\"415\":[99.17,25.12],\"416\":[103.72,27.33],\"417\":[100.23,26.88],\"419\":[100.08,23.88],\"496\":[120.2,23.0],\"421\":[103.4,23.37],\"300\":[114.88,30.4],\"301\":[112.2,31.03],\"302\":[113.92,30.93],\"303\":[112.23,30.33],\"424\":[99.97,25.42],\"304\":[114.87,30.45],\"305\":[114.32,29.85],\"306\":[113.37,31.72],\"428\":[91.13,29.65],\"307\":[109.47,30.3],\"308\":[113.45,30.37],\"309\":[112.88,30.42],\"422\":[104.25,23.37],\"431\":[88.88,29.27],\"310\":[113.17,30.67],\"311\":[110.67,31.75],\"312\":[112.93,28.23],\"313\":[113.13,27.83],\"314\":[112.93,27.83],\"402\":[102.27,27.9],\"435\":[108.93,34.27],\"436\":[108.93,34.9],\"315\":[112.57,26.9],\"316\":[111.47,27.25],\"437\":[107.13,34.37],\"438\":[108.7,34.33],\"317\":[113.12,29.37],\"318\":[111.68,29.05],\"439\":[109.5,34.5],\"319\":[110.47,29.13],\"426\":[98.85,25.85],\"440\":[109.48,36.6],\"320\":[112.32,28.6],\"441\":[107.02,33.07],\"200\":[118.78,32.07],\"442\":[109.73,38.28],\"321\":[113.02,25.78],\"443\":[109.02,32.68],\"322\":[111.62,26.43],\"201\":[120.3,31.57],\"202\":[117.18,34.27],\"444\":[109.93,33.87],\"323\":[110.0,27.57],\"324\":[112.0,27.73],\"445\":[103.82,36.07],\"203\":[119.95,31.78],\"325\":[109.73,28.32],\"446\":[98.27,39.8],\"204\":[120.58,31.3],\"447\":[102.18,38.5],\"326\":[113.5107,23.2196],\"205\":[120.88,31.98],\"327\":[113.6,24.82],\"206\":[119.22,34.6],\"448\":[104.18,36.55],\"449\":[105.72,34.58],\"207\":[119.02,33.62],\"328\":[114.05,22.55],\"329\":[113.57,22.27],\"462\":[102.02,35.52],\"208\":[120.15,33.35],\"209\":[119.4,32.4],\"401\":[101.97,30.05],\"450\":[102.63,37.93],\"451\":[100.45,38.93],\"330\":[116.68,23.35],\"331\":[113.12,23.02],\"452\":[106.67,35.55],\"210\":[119.45,32.2],\"332\":[113.08,22.58],\"453\":[98.52,39.75],\"211\":[119.92,32.45],\"454\":[107.63,35.73],\"333\":[110.35,21.27],\"212\":[118.28,33.97],\"213\":[120.15,30.28],\"455\":[104.62,35.58],\"334\":[110.92,21.67],\"214\":[121.55,29.88],\"456\":[104.92,33.4],\"335\":[112.47,23.05],\"215\":[120.7,28.0],\"336\":[114.42,23.12],\"216\":[120.75,30.75],\"337\":[116.12,24.28],\"459\":[101.78,36.62],\"217\":[120.08,30.9],\"338\":[115.37,22.78],\"339\":[114.7,23.73],\"218\":[120.57,30.0],\"219\":[119.65,29.08],\"340\":[111.98,21.87],\"220\":[118.87,28.93],\"341\":[113.03,23.7],\"342\":[113.75,23.05],\"221\":[122.2,30.0],\"222\":[121.43,28.68],\"343\":[113.38,22.52],\"344\":[116.62,23.67],\"223\":[119.92,28.45],\"224\":[117.25,31.83],\"345\":[116.37,23.55],\"346\":[112.03,22.92],\"225\":[118.38,31.33],\"467\":[106.28,38.47],\"468\":[106.38,39.02],\"226\":[117.38,32.92],\"347\":[108.37,22.82],\"348\":[109.42,24.33],\"469\":[106.2,37.98],\"227\":[117.0,32.63],\"349\":[110.28,25.28],\"228\":[118.5,31.7],\"229\":[116.8,33.95],\"470\":[106.28,36.0],\"350\":[111.27,23.48],\"471\":[105.18,37.52],\"230\":[117.82,30.93],\"351\":[109.12,21.48],\"472\":[87.62,43.82],\"231\":[117.05,30.53],\"473\":[84.87,45.6],\"352\":[108.35,21.7],\"474\":[89.17,42.95],\"353\":[108.62,21.95],\"232\":[118.33,29.72],\"475\":[93.52,42.83],\"233\":[118.32,32.3],\"354\":[109.6,23.1],\"355\":[110.17,22.63],\"234\":[115.82,32.9],\"235\":[116.98,33.63],\"356\":[106.62,23.9],\"236\":[117.87,31.6],\"357\":[111.55,24.42],\"358\":[108.07,24.7],\"479\":[80.27,41.17],\"237\":[116.5,31.77],\"359\":[109.23,23.73],\"238\":[115.78,33.85],\"239\":[117.48,30.67],\"11\":[126.66,45.74],\"12\":[118.76,32.06],\"13\":[120.153,30.26],\"14\":[117.28,31.86],\"15\":[119.296,26.0998],\"16\":[115.91,28.674],\"17\":[117.02,36.668],\"18\":[113.75,34.765],\"464\":[100.23,34.48],\"19\":[114.34,30.54],\"360\":[107.37,22.4],\"481\":[75.98,39.47],\"240\":[118.75,30.95],\"361\":[110.32,20.03],\"482\":[79.92,37.12],\"362\":[109.5,18.25],\"241\":[119.3,26.08],\"484\":[82.98,46.75],\"363\":[109.52,18.78],\"242\":[118.08,24.48],\"364\":[110.47,19.25],\"485\":[88.13,47.85],\"243\":[119.0,25.43],\"244\":[117.62,26.27],\"486\":[86.03,44.3],\"365\":[109.57,19.52],\"366\":[110.8,19.55],\"245\":[118.67,24.88],\"487\":[81.28,40.55],\"246\":[117.65,24.52],\"367\":[110.4,18.8],\"488\":[79.13,39.85],\"247\":[118.17,26.65],\"368\":[108.63,19.1],\"489\":[87.53,44.17],\"248\":[117.03,25.1],\"369\":[110.32,19.7],\"249\":[119.52,26.67],\"20\":[112.98,28.11],\"21\":[113.258,23.13],\"22\":[108.32,22.81],\"24\":[104.076,30.65],\"25\":[106.707,26.598],\"26\":[102.71,25.046],\"27\":[91.117,29.64],\"28\":[108.95,34.26],\"29\":[103.82,36.059],\"5\":[106.55,29.57],\"370\":[110.1,19.37],\"250\":[115.85,28.68],\"492\":[121.73,25.13],\"371\":[110.0,19.73],\"372\":[109.68,19.92],\"130\":[114.52,38.05],\"251\":[117.17,29.27],\"131\":[118.2,39.63],\"373\":[109.45,19.23],\"252\":[113.85,27.63],\"374\":[109.05,19.25],\"253\":[116.0,29.7],\"132\":[119.6,39.93],\"133\":[114.48,36.62],\"375\":[109.17,18.75],\"254\":[114.92,27.82],\"376\":[110.03,18.5],\"255\":[117.07,28.27],\"134\":[114.48,37.07],\"498\":[121.3,24.97],\"256\":[114.93,25.83],\"377\":[109.7,18.63],\"135\":[115.47,38.87],\"257\":[114.98,27.12],\"378\":[109.83,19.03],\"136\":[114.88,40.82],\"137\":[117.93,40.97],\"258\":[114.38,27.8],\"138\":[116.83,38.3],\"259\":[116.35,28.0],\"139\":[116.7,39.52],\"30\":[101.78,36.62],\"31\":[106.258,38.47],\"32\":[87.627,43.79],\"33\":[121.5,25.0],\"34\":[114.08,22.2],\"35\":[113.33,22.13],\"260\":[117.97,28.45],\"382\":[104.07,30.67],\"261\":[116.98,36.67],\"140\":[115.68,37.73],\"383\":[104.78,29.35],\"262\":[120.38,36.07],\"141\":[112.55,37.87],\"263\":[118.05,36.82],\"384\":[101.72,26.58],\"142\":[113.3,40.08],\"143\":[113.57,37.85],\"264\":[117.32,34.82],\"385\":[105.43,28.87],\"386\":[104.38,31.13],\"265\":[118.67,37.43],\"144\":[113.12,36.2],\"387\":[104.73,31.47],\"145\":[112.83,35.5],\"266\":[121.43,37.45],\"146\":[112.43,39.33],\"267\":[119.15,36.7],\"388\":[105.83,32.43],\"147\":[112.75,37.68],\"389\":[105.57,30.52],\"268\":[116.58,35.42],\"269\":[117.08,36.2],\"148\":[110.98,35.02],\"149\":[112.73,38.42],\"2\":[116.4,39.9],\"420\":[101.55,25.03],\"390\":[105.05,29.58],\"391\":[103.77,29.57],\"270\":[122.12,37.52],\"271\":[119.52,35.42],\"150\":[111.52,36.08],\"392\":[106.08,30.78],\"272\":[117.67,36.22],\"393\":[103.83,30.05],\"151\":[111.13,37.52],\"273\":[118.35,35.05],\"152\":[111.73,40.83],\"394\":[104.62,28.77],\"395\":[106.63,30.47],\"274\":[116.3,37.45],\"153\":[109.83,40.65],\"154\":[106.82,39.67],\"275\":[115.98,36.45],\"396\":[107.5,31.22],\"155\":[118.92,42.27],\"397\":[103.0,29.98],\"276\":[117.97,37.38],\"398\":[106.77,31.85],\"156\":[122.27,43.62],\"399\":[104.65,30.12],\"157\":[109.8,39.62],\"278\":[113.62,34.75],\"279\":[114.3,34.8],\"158\":[119.77,49.22],\"159\":[107.42,40.75],\"166\":[122.98,41.1],\"466\":[97.37,37.37],\"280\":[112.45,34.62],\"281\":[113.18,33.77],\"160\":[113.12,40.98],\"161\":[122.05,46.08],\"282\":[114.38,36.1],\"283\":[114.28,35.75],\"162\":[116.07,43.95],\"163\":[105.67,38.83],\"284\":[113.9,35.3],\"164\":[123.43,41.8],\"285\":[113.25,35.22],\"286\":[115.03,35.77],\"165\":[121.62,38.92],\"287\":[113.85,34.03],\"167\":[123.98,41.88],\"288\":[114.02,33.58],\"168\":[123.77,41.3],\"289\":[111.2,34.78],\"169\":[124.38,40.13],\"176\":[120.45,41.57],\"290\":[112.52,33.0],\"170\":[121.13,41.1],\"291\":[115.65,34.45],\"171\":[122.23,40.67],\"292\":[114.07,32.13],\"293\":[114.65,33.62],\"478\":[86.15,41.77],\"172\":[121.67,42.02],\"173\":[123.17,41.27],\"294\":[114.02,32.98],\"174\":[122.07,41.12],\"295\":[114.3,30.6],\"175\":[123.83,42.28],\"296\":[115.03,30.2],\"297\":[110.78,32.65],\"298\":[111.28,30.7],\"177\":[120.83,40.72],\"178\":[125.32,43.9],\"430\":[91.77,29.23],\"180\":[124.35,43.17],\"181\":[125.13,42.88],\"182\":[125.93,41.73],\"183\":[126.42,41.93],\"184\":[124.82,45.13],\"185\":[122.83,45.62],\"187\":[126.53,45.8],\"188\":[123.95,47.33],\"189\":[130.97,45.3],\"190\":[130.27,47.33],\"191\":[131.15,46.63],\"192\":[125.03,46.58],\"193\":[128.9,47.73],\"194\":[130.37,46.82],\"195\":[130.95,45.78],\"411\":[107.52,26.27],\"196\":[129.6,44.58],\"197\":[127.48,50.25],\"476\":[87.3,44.02],\"198\":[126.98,46.63],\"199\":[124.12,50.42],\"458\":[102.92,34.98],\"424\":[100.23,25.6],\"410\":[107.97,26.58],\"463\":[100.62,36.28],\"423\":[100.8,22.02],\"432\":[92.07,31.48],\"465\":[97.02,33.0]}");

	@SuppressWarnings("rawtypes")
	public static Object getClassFieldObj(Class clazz, String fieldName, String fieldValue){
		try {
			Class fieldClazz = clazz.getField(fieldName).getType();
			if(fieldClazz.getName().equals("short")){
				return Short.parseShort(fieldValue);
			}else if(fieldClazz.getName().equals("int")){
				return Integer.parseInt(fieldValue);
			}else if(fieldClazz.getName().equals("long")){
				return Long.parseLong(fieldValue);
			}else if(fieldClazz.getName().equals("float")){
				return Float.parseFloat(fieldValue);
			}else if(fieldClazz.getName().equals("double")){
				return Double.parseDouble(fieldValue);
			}else if(fieldClazz.getName().equals("boolean")){
				return Boolean.parseBoolean(fieldValue);
			}else if(fieldClazz.getName().equals("java.lang.String")){
				return fieldValue;
			}
		} catch (Exception e) {
			logger.error("有异常",e);
		}
		return null;
	}

	/**
	 * 获取用户token
	 * @return
	 */
	public static String getUserToken(){
		return USER_TOKEN_PREFIX+CommonUtil.getUUID();
	}
	/**
	 * 获取设备token
	 * @return
	 */
	public static String getDeviceToken(){
		return DEVICE_TOKEN_PREFIX+CommonUtil.getUUID();
	}
	/**
	 * 获取IPC服务器（网络监控摄像头的服务器）token
	 * @return
	 */
	public static String getIPCDeviceToken(){
		return DEVICE_IPC_TOKEN_PREFIX+CommonUtil.getUUID();
	}
	/**
	 * 获取系统用户token
	 * @return
	 */
	public static String getSysuserToken(){
		return SYSUSER_TOKEN_PREFIX+CommonUtil.getUUID();
	}
	/**
	 * 获取广告用户token
	 */
	public static String getAdUserToken(){
		return ADUSER_TOKEN_PREFIX+CommonUtil.getUUID();
	}
	/**
	 * 获取没有-的UUID
	 * @return
	 */
	public synchronized static String getUUID() {
		String s = UUID.randomUUID().toString();
		return s.replaceAll("-", "");
	}
	
	/**
	 * 获取请求ID
	 */
	public static String getRequestId(String projectName){
		return projectName+"-"+System.nanoTime();
	}
	
	/**
	 * 拼接
	 * @param arr 基础数据类型数组或字符串数组
	 * @param delim
	 * @return
	 */
	public static String join(Object[] arr, String delim){
		if (arr==null || arr.length==0) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < arr.length; i++) {
			if(arr[i]==null){
				continue;
			}
			if (i > 0) {
				sb.append(delim);
			}
			sb.append(arr[i]);
		}
		return sb.toString();
	}
	
	/**
	 * 获取验证redis key
	 * @param sessionId
	 * @return
	 */
	public static String getVerifyCodeRedisKey(String sessionId) {		
		return VERIFY_CODE_PREFIX + sessionId;
	}
	/**
	 * 生成验证码 随机码
	 * @param simple 是否要简单的验证码
	 * @param length 验证码长度
	 * @return
	 */
	public static String makeVerifyNum(boolean simple, int length){
		final char[] legalChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
		StringBuilder sb = new StringBuilder();
		Random random = new Random();
		short len = 62;
		if(simple){
			len = 10;
		}
		for (int i = 0; i < length; i++) {
			char rand = legalChars[random.nextInt(len)];
			sb.append(rand);
		}
		String sjm = sb.toString();
		sb = null;
		random=null;
		return sjm;
	}
	
	/**
	 * 数据模型属性转表字段<br>
	 * 将数据模型属性的大写字母转为_小写字母<br>
	 * 如 数据模型属性 userId 那么表字段为 user_id<br>
	 * @param field
	 * @return
	 */
	public static String field2Column(String field){
		 //a=97 z=122 A=65 Z=90
		if(field==null)return null;
		char[] value = new char[100];
		int count=0;
		for(int i=0; i<field.length(); i++){
			char c = field.charAt(i);
			if(65<=c  && c <= 90){//大写
				c = (char) (c + 32);
				value[count] = '_';
				count++;
			}
			value[count] = c;
			count++;
		}
		String column = new String(value, 0, count);
		value = null;
		return column;
	}

	/**
	 * 获取工单号
	 */
	public static String getFeedbackNum(boolean isUser){
		String r = makeVerifyNum(false, 3).toUpperCase();
		if(isUser){
			return "C"+String.valueOf(TimeUtil.getNowTime()).substring(2,12) + r;
		}else{
			return "S"+String.valueOf(TimeUtil.getNowTime()).substring(2,12) + r;
		}
	}

	public static String getOpenDoorLogKey(String communityId, String buildId, int openType, String openInfo) {
		String ret = "0";
		try {
			ret = OPEN_DOOR_LOG_PREFIX + getMD5((communityId + "_" + buildId + "_" + openType + "_" + openInfo).getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
			logger.error("有异常",e);
		}
		return ret;
	}

	public static String getCellIdListKey(String communityId, String userId) {
		return CELL_ID_LIST_PREFIX + communityId + userId;
	}
	public static String getMD5(byte[] bytes) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(bytes);
			return new BigInteger(1, md.digest()).toString(16);
		} catch (NoSuchAlgorithmException e) {
			return null;
		}
	}

	public static String trim(String str){
		if(StringUtil.notEmpty(str)){
			return str.trim();
		}else {
			return str;
		}
	}

}
