package com.zzwtec.wechat.sdk.utils;

import com.zzwtec.wechat.sdk.render.ContentType;
import com.zzwtec.wechat.sdk.render.JsonRender;
import com.zzwtec.wechat.sdk.render.Render;
import com.zzwtec.wechat.sdk.render.RenderFactory;

import java.io.File;
import java.util.Map;

/**
 * 渲染工具类
 * @author 毛文超
 * */
public class RenderUtil {

    public static RenderFactory renderFactory;

    /**
     * Render template to String content, it is useful for:
     * 1: Generate HTML fragment for AJAX request
     * 2: Generate email, short message and so on
     */
    public static String renderToString(String template, Map data) {
        return renderFactory.getEngine().getTemplate(template).renderToString(data);
    }

    /**
     * Render with JFinal template
     */
    public static void renderTemplate(String template) {
        renderFactory.getTemplateRender(template).render();
    }


    /**
     * Render with json
     * <p>
     * Example:<br>
     * renderJson("message", "Save successful");<br>
     * renderJson("users", users);<br>
     */
    public static void renderJson(String key, Object value) {
        renderFactory.getJsonRender(key, value).render();
    }

    /**
     * Render with json
     */
    public static void renderJson() {
        renderFactory.getJsonRender().render();
    }

    /**
     * Render with attributes set by setAttr(...) before.
     * <p>
     * Example: renderJson(new String[]{"blogList", "user"});
     */
    public static void renderJson(String[] attrs) {
        renderFactory.getJsonRender(attrs).render();
    }

    /**
     * Render with json text.
     * <p>
     * Example: renderJson("{\"message\":\"Please input password!\"}");
     */
    public static void renderJson(String jsonText) {
        renderFactory.getJsonRender(jsonText).render();
    }

    /**
     * Render json with object.
     * <p>
     * Example: renderJson(new User().set("name", "JFinal").set("age", 18));
     */
    public static void renderJson(Object object) {
       Render render = object instanceof JsonRender ? (JsonRender)object : renderFactory.getJsonRender(object);
       render.render();
    }

    /**
     * Render with text. The contentType is: "text/plain".
     */
    public static void renderText(String text) {
        renderFactory.getTextRender(text).render();
    }

    /**
     * Render with text and content type.
     * <p>
     * Example: renderText("&lt;user id='5888'&gt;James&lt;/user&gt;", "application/xml");
     */
    public static void renderText(String text, String contentType) {
        renderFactory.getTextRender(text, contentType).render();
    }

    /**
     * Render with text and ContentType.
     * <p>
     * Example: renderText("&lt;html&gt;Hello James&lt;/html&gt;", ContentType.HTML);
     */
    public static void renderText(String text, ContentType contentType) {
        renderFactory.getTextRender(text, contentType).render();
    }



    /**
     * Render with file
     */
    public static void renderFile(String fileName) {
        renderFactory.getFileRender(fileName).render();
    }

    /**
     * Render with file, using the new file name to the client
     */
    public static void renderFile(String fileName, String downloadFileName) {
        renderFactory.getFileRender(fileName, downloadFileName).render();
    }

    /**
     * Render with file
     */
    public static void renderFile(File file) {
        renderFactory.getFileRender(file).render();
    }

    /**
     * Render with file, using the new file name to the client
     */
    public static void renderFile(File file, String downloadFileName) {
        renderFactory.getFileRender(file, downloadFileName).render();
    }

    /**
     * Redirect to value
     */
    public static void redirect(String url) {
        renderFactory.getRedirectRender(url).render();
    }

    /**
     * Redirect to value
     */
    public static void redirect(String url, boolean withQueryString) {
        renderFactory.getRedirectRender(url, withQueryString).render();
    }

    /**
     * Render with view and status use default type Render configured in JFinalConfig
     */
    public static void render(String view, int status) {
        renderFactory.getRender(view,status).render();
    }

    public static void render(String view){
        render(view,200);
    }
    /**
     * Render with value and 301 status
     */
    public static void redirect301(String url) {
        renderFactory.getRedirect301Render(url).render();
    }

    /**
     * Render with value and 301 status
     */
    public static void redirect301(String url, boolean withQueryString) {
        renderFactory.getRedirect301Render(url, withQueryString).render();
    }


    /**
     * Render nothing, no response to browser
     */
    public static void renderNull() {
        renderFactory.getNullRender().render();
    }

    /**
     * Render with javascript text. The contentType is: "text/javascript".
     */
    public static void renderJavascript(String javascriptText) {
        renderFactory.getJavascriptRender(javascriptText).render();
    }

    /**
     * Render with html text. The contentType is: "text/html".
     */
    public static void renderHtml(String htmlText) {
        renderFactory.getHtmlRender(htmlText).render();
    }

    /**
     * Render with xml view using freemarker.
     */
    public static void renderXml(String view) {
        renderFactory.getXmlRender(view).render();
    }

    /**
     * 渲染二维码
     * @param content 二维码中所包含的数据内容
     * @param width 二维码宽度，单位为像素
     * @param height 二维码高度，单位为像素
     */
    public static void renderQrCode(String content, int width, int height) {
        renderFactory.getQrCodeRender(content, width, height).render();
    }

    /**
     * 渲染二维码，并指定纠错级别
     * @param content 二维码中所包含的数据内容
     * @param width 二维码宽度，单位为像素
     * @param height 二维码高度，单位为像素
     * @param errorCorrectionLevel 纠错级别，可设置的值从高到低分别为：'H'、'Q'、'M'、'L'，具体的纠错能力如下：
     *  H = ~30%
     *  Q = ~25%
     *  M = ~15%
     *  L = ~7%
     */
    public static void renderQrCode(String content, int width, int height, char errorCorrectionLevel) {
        renderFactory.getQrCodeRender(content, width, height, errorCorrectionLevel).render();
    }

}
