/**
 * Copyright (c) 2011-2017, James Zhan 詹波 (inlet@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.zzwtec.wechat.sdk.render;

import com.jfinal.template.Engine;
import com.zzwtec.wechat.sdk.utils.RenderUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.File;

/**
 * RenderFactory.
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
public class RenderFactory{
	private Engine engine = new Engine("Enjoy");

	@Autowired
	private ApplicationContext applicationContext;

	public RenderFactory(){
        TemplateRender.init(engine);
    }

    @PostConstruct
    public void init(){
        RenderUtil.renderFactory = this;
    }

    public Render getRender(String view, int status){
        Render templateRender = getTemplateRender(view);
        templateRender.response.setStatus(status);
        return templateRender;
    }
	
	public Render getTemplateRender(String view) {
        TemplateRender templateRender = new TemplateRender(view);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(templateRender);
		return templateRender;
	}
	
	public Render getJsonRender() {
        JsonRender jsonRender = new JsonRender();
        applicationContext.getAutowireCapableBeanFactory().autowireBean(jsonRender);
        return jsonRender;
	}
	
	public Render getJsonRender(String key, Object value) {
        JsonRender jsonRender = new JsonRender(key, value);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(jsonRender);
        return jsonRender;
	}
	
	public Render getJsonRender(String[] attrs) {
        JsonRender jsonRender = new JsonRender(attrs);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(jsonRender);
        return jsonRender;
	}
	
	public Render getJsonRender(String jsonText) {
        JsonRender jsonRender = new JsonRender(jsonText);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(jsonRender);
        return jsonRender;
	}
	
	public Render getJsonRender(Object object) {
        JsonRender jsonRender = new JsonRender(object);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(jsonRender);
        return jsonRender;
	}
	
	public Render getTextRender(String text) {
        TextRender textRender = new TextRender(text);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(textRender);
        return textRender;
	}
	
	public Render getTextRender(String text, String contentType) {
        TextRender textRender = new TextRender(text, contentType);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(textRender);
        return textRender;
	}
	
	public Render getTextRender(String text, ContentType contentType) {
        TextRender textRender = new TextRender(text, contentType);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(textRender);
        return textRender;
	}

	public Render getFileRender(String fileName) {
        FileRender fileRender = new FileRender(fileName);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(fileRender);
        return fileRender;
	}
	
	public Render getFileRender(String fileName, String downloadFileName) {
        FileRender fileRender = new FileRender(fileName, downloadFileName);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(fileRender);
        return fileRender;
	}
	
	public Render getFileRender(File file) {
        FileRender fileRender = new FileRender(file);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(fileRender);
        return fileRender;
	}
	
	public Render getFileRender(File file, String downloadFileName) {
        FileRender fileRender = new FileRender(file,downloadFileName);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(fileRender);
		return fileRender;
	}
	
	public Render getRedirectRender(String url) {
        RedirectRender redirectRender = new RedirectRender(url);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(redirectRender);
        return redirectRender;
	}
	
	public Render getRedirectRender(String url, boolean withQueryString) {
        RedirectRender redirectRender = new RedirectRender(url, withQueryString);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(redirectRender);
        return redirectRender;
	}
	
	public Render getRedirect301Render(String url) {
        Redirect301Render redirect301Render = new Redirect301Render(url);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(redirect301Render);
        return redirect301Render;
	}
	
	public Render getRedirect301Render(String url, boolean withQueryString) {
        Redirect301Render redirect301Render = new Redirect301Render(url, withQueryString);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(redirect301Render);
        return redirect301Render;
	}
	
	public Render getNullRender() {
        NullRender nullRender = new NullRender();
        applicationContext.getAutowireCapableBeanFactory().autowireBean(nullRender);
        return nullRender;
	}
	
	public Render getJavascriptRender(String jsText) {
        JavascriptRender javascriptRender = new JavascriptRender(jsText);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(javascriptRender);
        return javascriptRender;
	}
	
	public Render getHtmlRender(String htmlText) {
        HtmlRender htmlRender = new HtmlRender(htmlText);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(htmlRender);
        return htmlRender;
	}
	
	public Render getXmlRender(String view) {
        XmlRender xmlRender = new XmlRender(view);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(xmlRender);
        return xmlRender;
	}
	

	public Render getQrCodeRender(String content, int width, int height) {
        QrCodeRender qrCodeRender = new QrCodeRender(content, width, height);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(qrCodeRender);
        return qrCodeRender;
	}
	
	public Render getQrCodeRender(String content, int width, int height, char errorCorrectionLevel) {
        QrCodeRender qrCodeRender = new QrCodeRender(content, width, height, errorCorrectionLevel);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(qrCodeRender);
        return qrCodeRender;
	}

    public Engine getEngine() {
        return engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }
}


