package com.zzwtec.wechat.sdk.cache;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
public class RedisAccessTokenCache implements IAccessTokenCache {
    private static final String ACCESS_TOKEN_PREFIX = "inlet-weixin:token:";
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    public String get(String key) {
        return redisTemplate.opsForValue().get(ACCESS_TOKEN_PREFIX.concat(key));
    }

    @Override
    public void set(String key, String jsonValue) {
        redisTemplate.opsForValue().set(ACCESS_TOKEN_PREFIX.concat(key),jsonValue,DEFAULT_TIME_OUT, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        redisTemplate.delete(ACCESS_TOKEN_PREFIX.concat(key));
    }

}
