package com.zzwtec.wechat.rpc.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaoleilu.hutool.collection.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.zzwtec.jdbc.entity.ThirdUserWechat;
import com.zzwtec.jdbc.service.ThirdUserWechatService;
import com.zzwtec.wechat.common.constant.UrlConstants;
import com.zzwtec.wechat.config.WeChatConfig;
import com.zzwtec.wechat.rpc.APIResponse;
import com.zzwtec.wechat.rpc.annotation.ZZWApiAction;
import com.zzwtec.wechat.sdk.api.ApiConfigKit;
import com.zzwtec.wechat.util.SpringUtil;
import com.zzwtec.wechat.util.security.MyBase64Util;
import com.zzwtec.wechat.util.security.TokenUtil;

import static com.xiaoleilu.hutool.util.StrUtil.isEmpty;
import static com.zzwtec.wechat.util.CharUtil.PARA_SEPARATE;
import static com.zzwtec.wechat.util.CharUtil.makeVerifyNum;

/**
 *服务方法调用
 *@author 毛文超
 * */
public interface APIService {

    // 获取呼叫快照
    @ZZWApiAction("openAPI$admin/login")
    APIResponse adminLogin(String username,String password);
    // 获取呼叫快照
    @ZZWApiAction("openAPI$fileStore/queryCaptureURLByKey")
    APIResponse queryCaptureURLByKey(String captureKey);

    @ZZWApiAction("openAPI$fileStore/queryCaptureURLById")
    APIResponse queryCaptureURLById(String captureKey);

    // 获取呼叫记录
    @ZZWApiAction("openAPI$callLog/queryCallLogByPage")
    APIResponse getCallLog(String userId, int page, int pageNum);

    // 获取门列表
    @ZZWApiAction("openAPI$door/queryDoorByBuildId")
    APIResponse getDoorList(String communityId, String buildId, String token);

    //开门
    //待会写逻辑处理这个函数
    @ZZWApiAction("openAPI$openDoor/thirdOpenDoor")
    APIResponse thridOpenDoor(String token, String doorId, int appType, String feedbackURL);

    // 获取新闻公告列表
    @ZZWApiAction("openAPI$news/queryNoticeByCommunityId")
    APIResponse queryNoticeList(String communityId, int page, int pageNum);

    // 获取新闻公告详情
    @ZZWApiAction("openAPI$news/queryNoticeByNoticeId")
    APIResponse queryNoticeById(String id);

    // 绑定
//    @ZZWApiAction("openAPI$wechat/bindWechat")
//    APIResponse bindWechat(String phone, String openid, String appid);
//
//    // 解绑
//    @ZZWApiAction("openAPI$wechat/unBindWechat")
//    APIResponse unBindWechat(String phone, String openid, String appid);
    //根据手机号码查询住户
    @ZZWApiAction("openAPI$user/queryUserByPhone")
    APIResponse queryUserByPhone(String phone,String token);

    // 查询微信绑定关系
//    @ZZWApiAction("openAPI$wechat/queryWechatBindInfo")
//    APIResponse queryWechatBindInfo(String openid, String appid);

    // 查询微信用户信息
    @ZZWApiAction("openAPI$wechat/queryWechatUserInfoByOpenid")
    APIResponse queryWechatUserInfoByOpenid(String openid);

    // 保存微信用户信息
    @ZZWApiAction("openAPI$wechat/saveWechatUserInfo")
    APIResponse saveWechatUserInfo(JSONObject dataJson);

    // 查询用户信息
    @ZZWApiAction("openAPI$user/queryUserByUserId")
    APIResponse queryUserByUserId(String userId);

    // 修改用户姓名
    @ZZWApiAction("openAPI$user/updateUserByUserId")
    APIResponse userUpdate(String userId, String token, String userName, String userLoginphone, String defaultCell);

    // 通过手机号码检查用户是否存在
    @ZZWApiAction("openAPI$user/checkUserExistsByPhone")
    APIResponse checkUserByPhone(String phone);

    // 成员添加
    @ZZWApiAction("openAPI$user/addUserByUserCellInfo")
    APIResponse memberAdd(int type, String cellId, String userLoginphone, String userName, String token);

    // 成员删除
    @ZZWApiAction("openAPI$user/deleteUserCellByUserIdCellId")
    APIResponse memberDel(String cellId, String userId, String token);

    // 修改房间信息
    @ZZWApiAction("openAPI$cell/updateCell")
    APIResponse updateCell(String buildId, String cellId, String name, String num, String address, boolean cancall, String callphone, String token);

    // 查询房间信息
    @ZZWApiAction("openAPI$cell/queryCellByCellId")
    APIResponse queryCell(String cellId);

    /**
     * 用queryUserCellByUserId替代queryUserAndCellByUserId接口的原因是 前者返回了小区id可以拥有数据权限判断
     * @param userId
     * @return
     */
    // 根据userId查询用户和房间信息
    @ZZWApiAction("openAPI$userCell/queryUserCellByUserId")
    APIResponse queryUserAndCellByUserId(String userId);


    // 根据cellId查询用户和房间信息
    @ZZWApiAction("openAPI$userCell/queryUserAndCellByCellId")
    APIResponse queryUserAndCellByCellId(String cellId);

    // 根据cellId查询小区配置
    @ZZWApiAction("openAPI$communityConfig/queryCommunityConfigByCellId")
    APIResponse queryCommunityConfigByCellId(String cellId);

    // 根据cellId查询小区/楼栋id
    @ZZWApiAction("openAPI$objRelation/queryObjRelationTreeByCellId")
    APIResponse findObjRelationTreeByCellId(String cellId);

    // 根据门ID查询门信息
    @ZZWApiAction("openAPI$door/queryDoorById")
    APIResponse queryDoorById(String doorId);

    // 查询全部微信营销消息 按序号排序
    @ZZWApiAction("openAPI$wechat/queryWechatNewsAll")
    APIResponse queryWechatNewsAll();


//    //关注微信公众号
//    @ZZWApiAction("other$UserWechatService/subscribeWechat")
//    APIResponse subscribeWechat(String openid);
//
//
//    //取消关注微信公众号
//    @ZZWApiAction("other$UserWechatService/unsubscribeWechat")
//    APIResponse unsubscribeWechat(String openid);

    // 上传住户人脸
    @ZZWApiAction("openAPI$user/updateFaceToken")
    APIResponse updateFaceToken(String userId,String face,String token);

    // 根据appid、openid查询user
    //默认方法
    default APIResponse findUserByAppidAndOpenid(String appid, String openid, APIService apiService) {
        // 查询微信关绑定系失败
//        APIResponse wechatResponse = apiService.queryWechatBindInfo(openid, appid);
//        if (wechatResponse.isFail()) {
//            return wechatResponse;
//        }
        // 没有绑定账号
//        String userId = apiService.getUserIdFromWechatBindJson(wechatResponse.getData());
//        if (isEmpty(userId)) {
//            return new APIResponse(420, "您还没有绑定账号");
//        }
        // 查询是否绑定账号
        ThirdUserWechatService service = SpringUtil.getBean(ThirdUserWechatService.class);
        ThirdUserWechat thirdUserWechat = service.queryUserWechatByOpenid(openid);
        if (thirdUserWechat == null) {
            return new APIResponse(420, "您还没有绑定账号");
        }
        String userId = thirdUserWechat.getUserId();
        // 查询用户信息失败
        APIResponse userResponse = apiService.queryUserByUserId(userId);
        if (userResponse.isFail()) {
            return userResponse;
        }
        // 用户不存在
        if (StrUtil.isEmpty(userResponse.getData())) {
            return new APIResponse(310, "查询不到您的用户信息");
        }
        return userResponse;

    }

    //默认方法
    default String getUserIdFromWechatBindJson(String json) {
        JSONArray jsonArray = JSONArray.parseArray(json);
        return CollectionUtil.isEmpty(jsonArray) ? null : ((JSONObject)jsonArray.get(0)).getString("userId");
    }

    //查询房产
    //这个得写默认方法
    default APIResponse findUserAndCellByUserId(String userId, APIService apiService) {

        APIResponse apiResponse = apiService.queryUserAndCellByUserId(userId);
        // 没有房产
        if (apiResponse.isSuccess() && isEmpty(apiResponse.getData())) {
            return new APIResponse(1, "您没有房产");
        }


        return apiResponse;
    }

    //第三方开门
    default APIResponse thridOpenDoor(String openid, String doorId, APIService service) {
        long nowTime = System.currentTimeMillis();
        String appId = ApiConfigKit.getAppId();
        String encode = MyBase64Util.encode(appId + PARA_SEPARATE + openid + PARA_SEPARATE + doorId + PARA_SEPARATE + nowTime + PARA_SEPARATE + TokenUtil.getToken());
        String token = makeVerifyNum(false, 16);
        String feedbackURL = WeChatConfig.weChatConfig.getHost() + UrlConstants.PUSH_DOOR_OPEN + "?e=" + encode;
        return service.thridOpenDoor(token,doorId,1,feedbackURL);
    }

}
