package com.zzwtec.wechat.controller;

import com.alibaba.fastjson.JSONObject;
import com.zzwtec.third.common.UrlContents;
import com.zzwtec.wechat.config.WeChatConfig;
import com.zzwtec.wechat.sdk.api.ApiResult;
import com.zzwtec.wechat.sdk.api.MenuApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 微信自定义菜单
 * @author ShangJia
 * @date 2018/12/18
 */
@RequestMapping("wechat/menu")
@Controller
public class WechatMenuController {
    private Logger logger = LoggerFactory.getLogger(WechatMenuController.class);
    @Autowired
    private WeChatConfig weChatConfig;
    @RequestMapping("/create")
    public String creatMenu() {
        String host=weChatConfig.getHost();
        //菜单模版json
        String templateJson = "{\n" +
                "        \"button\": [\n" +
                "            {\n" +
                "                \"type\": \"click\", \n" +
                "                \"name\": \"开门\", \n" +
                "                \"key\": \"door\", \n" +
                "                \"sub_button\": [ ]\n" +
                "            }, \n" +
                "            {\n" +
                "               \"type\": \"view\", \n" +
                "                        \"name\": \"个人中心\", \n" +
                "                        \"url\": \""+host+"/info/wechatOauth2\",\n" +
                "                        \"sub_button\": [ ]\n" +
                "            }, \n" +
                "            {\n" +
                "                \"type\": \"click\", \n" +
                "                \"name\": \"公告\", \n" +
                "                \"key\": \"msg\", \n" +
                "                \"sub_button\": [ ]\n" +
                "     \n" +
                "            }\n" +
                "        ]\n" +
                "}";
        ApiResult apiResult = MenuApi.createMenu(templateJson);
        return apiResult.getJson();
    }

    @RequestMapping("/get")
    public String getMenu() {
        ApiResult apiResult = MenuApi.getMenu();
        String result = apiResult.getJson();
        return result;
    }

    @RequestMapping("delete")
    public String deleteMenu() {
        ApiResult apiResult =  MenuApi.deleteMenu();
        return apiResult.getJson();
    }
}
