package com.zzwtec.wechat.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import com.xiaoleilu.hutool.dfa.WordTree;
import com.zzwtec.jdbc.entity.ThirdUserWechat;
import com.zzwtec.jdbc.service.ThirdUserWechatService;
import com.zzwtec.third.utils.StringUtil;
import com.zzwtec.wechat.biz.EventBiz;
import com.zzwtec.wechat.common.constant.UrlConstants;
import com.zzwtec.wechat.config.WeChatConfig;
import com.zzwtec.wechat.dfa.DFAWordTree;
import com.zzwtec.wechat.rpc.APIResponse;
import com.zzwtec.wechat.rpc.api.APIService;
import com.zzwtec.wechat.rpc.inject.ProxyBuilder;
import com.zzwtec.wechat.sdk.aop.annotation.ZZWMsgController;
import com.zzwtec.wechat.sdk.api.SnsAccessTokenApi;
import com.zzwtec.wechat.sdk.inlet.MsgController;
import com.zzwtec.wechat.sdk.msg.in.*;
import com.zzwtec.wechat.sdk.msg.in.card.*;
import com.zzwtec.wechat.sdk.msg.in.event.*;
import com.zzwtec.wechat.sdk.msg.in.speech_recognition.InSpeechRecognitionResults;
import com.zzwtec.wechat.service.LoginService;
import com.zzwtec.wechat.util.CharUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

import static com.zzwtec.wechat.sdk.api.ApiConfigKit.getAppId;
import static com.zzwtec.wechat.sdk.utils.RenderUtil.renderNull;

/**
 * 来做微信的事件
 *
 * @author 邓燎燕
 *         2016年4月28日
 */
@Controller
@RequestMapping("/wx")
@ZZWMsgController
public class WeChatEventController extends MsgController {
    @Autowired
    private LoginService loginService;
    private static final Logger logger = LoggerFactory.getLogger(WeChatEventController.class);
    private static final APIService apiService = ProxyBuilder.build(APIService.class,WeChatConfig.weChatConfig);

    @Autowired
    private ThirdUserWechatService thirdUserWechatService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    /**
     * 处理接收到的文本消息
     */
    @Override
    protected void processInTextMsg(InTextMsg inTextMsg) {
        String content = inTextMsg.getContent();
        if ("产品".equals(inTextMsg.getContent())) {
            String productVideo = WeChatConfig.weChatConfig.getProductVideo();
            if (productVideo != null && productVideo.length() > 0) {
                renderOutTextMsg("欢迎使用智之屋\n\n请点击<a href=\"" + productVideo + "\">“观看产品视频”</a>");
            }
        }
        List<DFAWordTree> wordTreeList = WeChatConfig.weChatConfig.getWordTreeList();
        for (DFAWordTree dfaWordTree : wordTreeList) {
            WordTree wordTree = dfaWordTree.getWordTree();
            boolean match = wordTree.isMatch(content);
            if(match){
                renderOutTextMsg(dfaWordTree.getReplayContent());
                return;
            }
        }

        //指定关键词回复
    }

    /**
     * 处理接收到的图片消息
     */
    @Override
    protected void processInImageMsg(InImageMsg inImageMsg) {
        renderOutTextMsg("消息已成功接收，url为: " + inImageMsg.getPicUrl());
    }

    /**
     * 处理接收到的语音消息
     */
    @Override
    protected void processInVoiceMsg(InVoiceMsg inVoiceMsg) {
        renderOutTextMsg("消息已成功接收，mediaId为: " + inVoiceMsg.getMediaId());
    }

    /**
     * 处理接收到的视频消息
     */
    @Override
    protected void processInVideoMsg(InVideoMsg inVideoMsg) {
        renderOutTextMsg("消息已成功接收，mediaId为: " + inVideoMsg.getMediaId());
    }

    /**
     * 处理接收到的视频消息
     */
    @Override
    protected void processInShortVideoMsg(InShortVideoMsg inShortVideoMsg) {
        renderOutTextMsg("\t视频消息已成功接收，该视频的 mediaId 为: " + inShortVideoMsg.getMediaId());
    }

    /**
     * 处理接收到的地址位置消息
     */
    @Override
    protected void processInLocationMsg(InLocationMsg inLocationMsg) {
        renderOutTextMsg("消息已成功接收，位置信息为: " + inLocationMsg.getLabel());
    }

    /**
     * 处理接收到的链接消息
     */
    @Override
    protected void processInLinkMsg(InLinkMsg inLinkMsg) {
        renderOutTextMsg("消息已成功接收，url为: " + inLinkMsg.getUrl());
    }

    /**
     * 处理接收到的多客服管理事件
     */
    @Override
    protected void processInCustomEvent(InCustomEvent inCustomEvent) {
        renderOutTextMsg("processInCustomEvent() 方法测试成功");
    }

    /**
     * 处理接收到的关注/取消关注事件
     */
    @Override
    protected void processInFollowEvent(InFollowEvent inFollowEvent) {
        String openId = inFollowEvent.getFromUserName();
        boolean isSubscribe = inFollowEvent.getEvent().equals("subscribe");
        iceProcessInFollowEvent(openId, isSubscribe);
    }

    /**
     * 处理接收到的扫描带参数二维码事件
     */
    @Override
    protected void processInQrCodeEvent(InQrCodeEvent inQrCodeEvent) {
        if (InQrCodeEvent.EVENT_INQRCODE_SUBSCRIBE.equals(inQrCodeEvent.getEvent())) {
            //用户未关注时，进行关注后的事件推送
            final String openid = inQrCodeEvent.getFromUserName();
            logger.debug("扫码未关注：" + openid);
            renderOutTextMsg("感谢您的关注，二维码内容：" + inQrCodeEvent.getEventKey());
            iceProcessInFollowEvent(openid, true);
        } else if (InQrCodeEvent.EVENT_INQRCODE_SCAN.equals(inQrCodeEvent.getEvent())) {
            //用户已关注时的事件推送
            logger.debug("扫码已关注：" + inQrCodeEvent.getFromUserName());
            String key = inQrCodeEvent.getEventKey();
            renderOutTextMsg(key);
        }
    }

    /**
     * 处理接收到的上报地理位置事件
     */
    @Override
    protected void processInLocationEvent(InLocationEvent inLocationEvent) {
        logger.debug("测试方法：processInLocationEvent()");
        renderNull();
    }

    /**
     * 处理接收到的群发任务结束时通知事件
     */
    @Override
    protected void processInMassEvent(InMassEvent inMassEvent) {
        logger.debug("测试方法：processInMassEvent()");
        renderNull();
    }

    /**
     * 处理接收到的自定义菜单事件
     */
    @Override
    protected void processInMenuEvent(InMenuEvent inMenuEvent) {
        String key = inMenuEvent.getEventKey();
        String openid = inMenuEvent.getFromUserName();
        String tokenId=loginService.getLoginToken();
        String adminCommunityIds=redisTemplate.opsForValue().get("adminCommunityIds");
        String[] communityIds=StringUtil.notEmpty(adminCommunityIds)?adminCommunityIds.split(","):new String[0];

        logger.debug("processInMenuEvent key:" + key);
        switch (key) {
            case EventBiz.KEY_MSG:
                //公告
                EventBiz.msgEven(getAppId(), openid, this,communityIds);

                break;
            case EventBiz.KEY_DOOR:
                //开门
                EventBiz.doorEven(getAppId(), openid, this,tokenId,communityIds);

                break;
            case EventBiz.KEY_INFO:
                //个人中心
                renderNull();
                break;
            default:
                renderNull();
                break;
        }
    }

    /**
     * 处理接收到的语音识别结果
     */
    @Override
    protected void processInSpeechRecognitionResults(InSpeechRecognitionResults inSpeechRecognitionResults) {
        logger.debug("语音识别事件：" + inSpeechRecognitionResults.getFromUserName());
        renderOutTextMsg("语音识别结果： " + inSpeechRecognitionResults.getRecognition());
    }

    /**
     * 处理接收到的模板消息是否送达成功通知事件
     */
    @Override
    protected void processInTemplateMsgEvent(InTemplateMsgEvent inTemplateMsgEvent) {
        String status = inTemplateMsgEvent.getStatus();
        renderOutTextMsg("模板消息是否接收成功：" + status);
    }

    /**
     * 处理微信摇一摇事件
     */
    @Override
    protected void processInShakearoundUserShakeEvent(InShakearoundUserShakeEvent inShakearoundUserShakeEvent) {
        logger.debug("摇一摇周边设备信息通知事件：" + inShakearoundUserShakeEvent.getFromUserName());
        renderOutTextMsg("摇一摇周边设备信息通知事件UUID：" + inShakearoundUserShakeEvent.getUuid());
    }

    /**
     * 资质认证成功 || 名称认证成功 || 年审通知 || 认证过期失效通知
     */
    @Override
    protected void processInVerifySuccessEvent(InVerifySuccessEvent inVerifySuccessEvent) {
        logger.debug("资质认证成功通知事件：" + inVerifySuccessEvent.getFromUserName());
        renderOutTextMsg("资质认证成功通知事件：" + inVerifySuccessEvent.getExpiredTime());
    }

    /**
     * 资质认证失败 || 名称认证失败
     */
    @Override
    protected void processInVerifyFailEvent(InVerifyFailEvent inVerifyFailEvent) {
        logger.debug("资质认证失败通知事件：" + inVerifyFailEvent.getFromUserName());
        renderOutTextMsg("资质认证失败通知事件：" + inVerifyFailEvent.getFailReason());
    }

    /**
     * 门店在审核事件消息
     */
    @Override
    protected void processInPoiCheckNotifyEvent(InPoiCheckNotifyEvent inPoiCheckNotifyEvent) {
        logger.debug("processInPoiCheckNotifyEvent()");
        renderOutTextMsg("processInPoiCheckNotifyEvent()");
    }

    @Override
    protected void processInWifiEvent(InWifiEvent var1) {
        logger.debug("processInWifiEvent()");
        renderOutTextMsg("processInWifiEvent()");
    }

    @Override
    protected void processInUserCardEvent(InUserCardEvent var1) {
        logger.debug("processInUserCardEvent()");
        renderOutTextMsg("processInUserCardEvent()");
    }

    @Override
    protected void processInUpdateMemberCardEvent(InUpdateMemberCardEvent var1) {
        logger.debug("processInUpdateMemberCardEvent()");
        renderOutTextMsg("processInUpdateMemberCardEvent()");
    }

    @Override
    protected void processInUserPayFromCardEvent(InUserPayFromCardEvent var1) {
        logger.debug("processInUserPayFromCardEvent()");
        renderOutTextMsg("processInUserPayFromCardEvent()");
    }

    @Override
    protected void processInMerChantOrderEvent(InMerChantOrderEvent var1) {
        logger.debug("processInMerChantOrderEvent()");
        renderOutTextMsg("processInMerChantOrderEvent()");
    }

    @Override
    protected void processIsNotDefinedEvent(InNotDefinedEvent var1) {
        logger.debug("processIsNotDefinedEvent()");
        renderOutTextMsg("processIsNotDefinedEvent()");
    }

    @Override
    protected void processIsNotDefinedMsg(InNotDefinedMsg var1) {
        logger.debug("processIsNotDefinedMsg()");
        renderOutTextMsg("processIsNotDefinedMsg()");
    }

    @Override
    protected void processInUserGiftingCardEvent(InUserGiftingCardEvent var1) {
        logger.debug("processInUserGiftingCardEvent()");
        renderOutTextMsg("processInUserGiftingCardEvent()");
    }

    @Override
    protected void processInUserGetCardEvent(InUserGetCardEvent var1) {
        logger.debug("processInUserGetCardEvent()");
        renderOutTextMsg("processInUserGetCardEvent()");
    }

    @Override
    protected void processInUserConsumeCardEvent(InUserConsumeCardEvent var1) {
        logger.debug("processInUserConsumeCardEvent()");
        renderOutTextMsg("processInUserConsumeCardEvent()");
    }

    @Override
    protected void processInCardSkuRemindEvent(InCardSkuRemindEvent var1) {
        logger.debug("processInCardSkuRemindEvent()");
        renderOutTextMsg("processInCardSkuRemindEvent()");
    }

    @Override
    protected void processInCardPayOrderEvent(InCardPayOrderEvent var1) {
        logger.debug("processInCardPayOrderEvent()");
        renderOutTextMsg("processInCardPayOrderEvent()");
    }

    @Override
    protected void processInCardPassCheckEvent(InCardPassCheckEvent var1) {
        logger.debug("processInCardPassCheckEvent()");
        renderOutTextMsg("processInCardPassCheckEvent()");
    }



    private void iceProcessInFollowEvent(String openid, boolean isSubscribe) {
        // 取消关注
        if (!isSubscribe){
            thirdUserWechatService.modifyUserWechatDeletec(openid, true);
            renderOutTextMsg("欢迎下次再使用 :)");
            return;
        }

        // 关注
        thirdUserWechatService.modifyUserWechatDeletec(openid, false);

        // 获取用户是否已经绑定(存在于third_user_wechat表中)
        ThirdUserWechat thirdUserWechat = thirdUserWechatService.queryUserWechatByOpenid(openid);
        if (thirdUserWechat == null) { // 未绑定
            String url = createBindURL();
            renderOutTextMsg("欢迎使用\n你未绑定账号，请点击<a href=\"" + url + "\">“绑定账号”</a>");
        } else { // 已绑定
            renderOutTextMsg("欢迎使用 :)");
        }
    }

    private String createBindURL() {
        String url = CharUtil.encode(WeChatConfig.weChatConfig.getHost() + UrlConstants.INFO_BING);
        System.out.println(CharUtil.decode(url));
        return SnsAccessTokenApi.getAuthorizeURL(getAppId(), url, getAppId(), false);
    }

    private boolean checkUserCell(String appId, String openid){
        boolean result=false;
        String communityId="";
        // 查询用户
        APIResponse userResponse = apiService.findUserByAppidAndOpenid(appId, openid,apiService);
        if (userResponse.isFail()) {
            return result;
        }

        JSONObject userData = JSONObject.parseObject(userResponse.getData());
        String selCell =userData!=null? userData.getString("selCell"):"";
        //当前没有选择房产
        if(StrKit.isBlank(selCell)){
            return result;
        }else{
            APIResponse configResponse = apiService.queryCommunityConfigByCellId(selCell);
            if (configResponse.isFail()) {
                return result;
            }else{
                JSONObject communityData = JSONObject.parseObject(configResponse.getData());
                communityId=communityData!=null?communityData.getString("id"):"";
            }
        }
        if(communityId!=""){
            String adminCommunityIds=redisTemplate.opsForValue().get("adminCommunityIds");
            if(StringUtil.notEmpty(adminCommunityIds)){
                String[] communityIds=adminCommunityIds.split(",");
                for(String cid:communityIds){
                    if(communityId.equals(cid)){
                        result=true;
                        break;
                    }
                }
            }
        }

    return result;

    }

}
