package com.zzwtec.wechat.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import com.zzwtec.wechat.config.WeChatConfig;
import com.zzwtec.wechat.rpc.APIResponse;
import com.zzwtec.wechat.rpc.api.APIService;
import com.zzwtec.wechat.rpc.inject.ProxyBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 公告控制器
 *
 * @author 邓燎燕
 *         2016年5月9日
 */
@Controller
@RequestMapping("/cmsg")
public class NoticeController {
    @Autowired
    private HttpServletRequest request;
    private static final APIService service = ProxyBuilder.build(APIService.class, WeChatConfig.weChatConfig);
    /**
     * 查看更多发布公告
     * v0 openid
     * v1 communityId
     * v2 buildId
     * v3 cellId
     * v4 page
     */
    @RequestMapping("/getmsglist")
    public String getMsgList(String openid,String communityId,String buildId,String cellId,@RequestParam(defaultValue = "1") int page) {

        // 查询公告
        APIResponse response = service.queryNoticeList(communityId, page, 12);
        if (!APIResponse.isSuccess(response)) {
            return "/common/view/failure_tips.html";
        }
        // 没有公告
        JSONObject pageObject = JSONObject.parseObject(response.getData());
        if (pageObject == null || pageObject.get("data") == null) {

            return "";
        }
        JSONArray noticeArr = JSONArray.parseArray(pageObject.getString("data"));
        if (noticeArr == null || noticeArr.size() == 0) {
            return "";
        }
        //
        List<Map<String, Object>> noticeList = new ArrayList<>();
        Pattern pattern = Pattern.compile("^\\[(.*)\\]\\((.*)\\)$");
        for (int i = 0; i < noticeArr.size(); i++) {
            JSONObject item = noticeArr.getJSONObject(i);
            String id = item.getString("noticeId");
            String title = item.getString("noticeTitle");

            String url;
            Matcher matcher = pattern.matcher(title);
            if (matcher.find()) {
                title = matcher.group(1);
                url = matcher.group(2);
            } else {
                url = "";
            }

            Map<String, Object> map = new HashMap<>();
            map.put("id", id);
            map.put("title", title);
            map.put("url", url);
            noticeList.add(map);
        }
        int total = pageObject.getIntValue("total");
        request.setAttribute("openid", openid);
        request.setAttribute("communityId", communityId);
        request.setAttribute("buildId", buildId);
        request.setAttribute("cellId", cellId);
        request.setAttribute("list", noticeList);
        request.setAttribute("total", total);
        request.setAttribute("page", page);
        return "/msg/view/msglist.html";
    }

    /**
     * 查看发布公告
     * v0 公告ID
     */
    @RequestMapping("/getmsg/{id}")
    public String getMsg(@PathVariable("id") String id) {
        if (StrKit.isBlank(id)) {
            return "";
        }
        APIResponse response = service.queryNoticeById(id);
        if (!APIResponse.isSuccess(response)) {
            return "/common/view/failure_tips.html";
        }
        JSONObject notice = JSONObject.parseObject(response.getData());
        if (notice == null) {
            request.setAttribute("title", "查询不到公告信息");
            request.setAttribute("msg", "查询不到公告信息");
            return "/msg/view/msg.html";
        }
        String title = notice.getString("noticeTitle");
        String msg = notice.getString("noticeContent");
        request.setAttribute("title", title);
        request.setAttribute("msg", msg);
        return "/msg/view/msg.html";
    }

}
