package com.zzwtec.wechat.config;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.zzwtec.wechat.common.oauth.OauthInfoInterceptor;
import com.zzwtec.wechat.sdk.aop.MsgInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.*;

import java.util.Collections;
import java.util.List;

@Configuration
public class WebMvcConfig extends WebMvcConfigurerAdapter {
    private final WeChatConfig weChatConfig;

    @Autowired
    public WebMvcConfig(WeChatConfig weChatConfig) {
        this.weChatConfig = weChatConfig;
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/static/**").addResourceLocations("classpath:/static/");
        registry.addResourceHandler("/common/static/js/**").addResourceLocations("classpath:/common/static/js/");
        registry.addResourceHandler("/community/**").addResourceLocations("classpath:/community/");

        super.addResourceHandlers(registry);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
        InterceptorRegistration inletInterceptor = registry.addInterceptor(new MsgInterceptor());
        InterceptorRegistration oauthInterceptor = registry.addInterceptor(new OauthInfoInterceptor());
        oauthInterceptor.addPathPatterns("/info/**");
        inletInterceptor.addPathPatterns("/wx/**");
    }
    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(SerializerFeature.PrettyFormat);
        fastConverter.setFastJsonConfig(fastJsonConfig);
        fastConverter.setSupportedMediaTypes(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        converters.add(fastConverter);
    }

}
