package com.zzwtec.wechat.config;

import com.xiaoleilu.hutool.dfa.WordTree;
import com.zzwtec.wechat.dfa.DFAWordTree;
import com.zzwtec.wechat.sdk.api.ApiConfig;
import com.zzwtec.wechat.sdk.api.ApiConfigKit;
import com.zzwtec.wechat.sdk.cache.IAccessTokenCache;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 微信配置
 * @author 毛文超
 * */

public class WeChatConfig extends ServiceConfig {

    public static WeChatConfig weChatConfig;

    @Autowired
    private IAccessTokenCache tokenCache;

    private String token;

    private String appId;

    private String appSecret;

    private int wxArticleCount;

    private boolean encryptMessage;

    private String encodingAesKey;

    private String host;

    private String wsHost;

    private String productVideo;

    private String zzwtecOpenApiBase;

    private String zzwtecSecretKey;

    private String xteaKey;

    private String xteaIv;

    private boolean devMode;

    private String profile;

    //模板消息id
    private String noticeTemplateId;
    private String visitTemplateId;
    private String feedbackTemplateId;


    /**
     * 关键词-回复内容对象
     * **/
    private Map<String,String> keyWordsMap = new LinkedHashMap<>();

    private List<DFAWordTree> wordTreeList = new ArrayList<>();


    public WeChatConfig() {
        super("weChatConfig");
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public int getWxArticleCount() {
        return wxArticleCount;
    }

    public void setWxArticleCount(int wxArticleCount) {
        this.wxArticleCount = wxArticleCount;
    }

    public boolean isEncryptMessage() {
        return encryptMessage;
    }
    public void setEncryptMessage(boolean encryptMessage) {
        this.encryptMessage = encryptMessage;
    }

    public String getEncodingAesKey() {
        return encodingAesKey;
    }

    public void setEncodingAesKey(String encodingAesKey) {
        this.encodingAesKey = encodingAesKey;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getWsHost() {
        return wsHost;
    }

    public void setWsHost(String wsHost) {
        this.wsHost = wsHost;
    }

    public String getProductVideo() {
        return productVideo;
    }

    public void setProductVideo(String productVideo) {
        this.productVideo = productVideo;
    }

    public String getZzwtecOpenApiBase() {
        return zzwtecOpenApiBase;
    }

    public void setZzwtecOpenApiBase(String zzwtecOpenApiBase) {
        super.addServiceMapping("openAPI",zzwtecOpenApiBase);
        this.zzwtecOpenApiBase = zzwtecOpenApiBase;
    }

    public String getProfile() {
        return profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getZzwtecSecretKey() {
        return zzwtecSecretKey;
    }

    public void setZzwtecSecretKey(String zzwtecSecretKey) {
        this.zzwtecSecretKey = zzwtecSecretKey;
    }

    public IAccessTokenCache getTokenCache() {
        return tokenCache;
    }

    public void setTokenCache(IAccessTokenCache tokenCache) {
        this.tokenCache = tokenCache;
    }

    public boolean isDevMode() {
        return devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public String getXteaKey() {
        return xteaKey;
    }

    public void setXteaKey(String xteaKey) {
        this.xteaKey = xteaKey;
    }

    public String getXteaIv() {
        return xteaIv;
    }

    public void setXteaIv(String xteaIv) {
        this.xteaIv = xteaIv;
    }

    public String getNoticeTemplateId() {
        return noticeTemplateId;
    }

    public void setNoticeTemplateId(String noticeTemplateId) {
        this.noticeTemplateId = noticeTemplateId;
    }

    public String getVisitTemplateId() {
        return visitTemplateId;
    }

    public void setVisitTemplateId(String visitTemplateId) {
        this.visitTemplateId = visitTemplateId;
    }

    public String getFeedbackTemplateId() {
        return feedbackTemplateId;
    }

    public void setFeedbackTemplateId(String feedbackTemplateId) {
        this.feedbackTemplateId = feedbackTemplateId;
    }

    public Map<String, String> getKeyWordsMap() {
        return keyWordsMap;
    }

    public void setKeyWordsMap(Map<String, String> keyWordsMap) {
        this.keyWordsMap = keyWordsMap;
    }

    public List<DFAWordTree> getWordTreeList() {
        return wordTreeList;
    }

    public boolean isPush(){
        return !StringUtils.equalsAnyIgnoreCase(profile,"pre");
    }


    void init(){
        ApiConfig apiConfig = new ApiConfig();
        apiConfig.setAppId(appId);
        apiConfig.setAppSecret(appSecret);
        apiConfig.setEncodingAesKey(encodingAesKey);
        apiConfig.setEncryptMessage(encryptMessage);
        apiConfig.setToken(token);

        ApiConfigKit.setAccessTokenCache(tokenCache);
        ApiConfigKit.setDevMode(devMode);
        ApiConfigKit.putApiConfig(apiConfig);

        for (Map.Entry<String, String> entry : keyWordsMap.entrySet()) {
            String keyWords = entry.getKey();
            String[] wordArrays = keyWords.split(",");
            if(wordArrays.length > 0){
                WordTree wordTree = new WordTree();
                for (String word : wordArrays) {
                    wordTree.addWord(word);
                }
                DFAWordTree dfaWordTree = new DFAWordTree();
                dfaWordTree.setWordTree(wordTree);
                dfaWordTree.setReplayContent(entry.getValue());
                wordTreeList.add(dfaWordTree);

            }

        }

        weChatConfig = this;
    }

    void destroy(){
        ApiConfigKit.removeApiConfig(appId);
    }


}
