package com.zzwtec.wechat.config;

import java.util.HashMap;
import java.util.Map;

/**
 * 服务配置类,用于映射不同服务的url
 * @author 毛文超
 * */
public class ServiceConfig {


    private final Map<String,String> serviceMapping = new HashMap<>(16);
    private final String serviceName;

    public ServiceConfig(String serviceName){
        this.serviceName = serviceName;
    }


    public ServiceConfig addServiceMapping(String key, String serviceBaseUrl){
        serviceMapping.put(key,serviceBaseUrl);
        return this;
    }

    public ServiceConfig removeServiceMapping(String key){
        serviceMapping.remove(key);
        return this;
    }

    public String getServiceName() {
        return serviceName;
    }

    public String getBaseServiceUrl(String baseServiceKey){
        return serviceMapping.get(baseServiceKey);
    }
}
