package com.zzwtec.wechat.config;

import com.jfinal.core.JFinal;
import com.jfinal.template.ext.spring.JFinalViewResolver;
import com.jfinal.template.source.ClassPathSourceFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @ClassName JFinalConfig
 * @Author Administrator
 * @Date 2018/12/11 0011 19:41
 */
@Configuration
public class JFinalConfig {



    @Bean
    public JFinalViewResolver jFinalViewResolver(WeChatConfig weChatConfig){
        JFinalViewResolverExt jfr = new JFinalViewResolverExt();
        jfr.setSourceFactory(new ClassPathSourceFactory());
        jfr.setEncoding("UTF-8");
        jfr.setDevMode(true);
        jfr.setAllowRequestOverride(true);
        jfr.setOrder(0);
        jfr.setContentType("text/html;charset=UTF-8");
        jfr.addSharedObject("WX_HOST",weChatConfig.getHost());
//        jfr.addSharedObject("WX_HOST",weChatConfig.getHostJs());
        jfr.setBaseTemplatePath("/templates");

        return jfr;
    }
}
