package com.zzwtec.wechat.common.oauth;

import com.zzwtec.wechat.sdk.api.SnsAccessToken;

/**
 *网页授权信息上下文.
 * @author 毛文超
 * */
public class SnsAccessTokenContext {

    private static final ThreadLocal<SnsAccessToken> SNS_ACCESS_TOKEN_CONTEXT = new InheritableThreadLocal<>();
    /**
     * 把SnsAccessToken放进全局的上下文中.
     * @param snsAccessToken 授权信息
     * */
    public static void setSnsAccessToken(SnsAccessToken snsAccessToken){
        SNS_ACCESS_TOKEN_CONTEXT.set(snsAccessToken);
    }
    /**
     * 获取上下文中的授权信息
     * @return snsAccessToken  授权信息
     * */
    public static SnsAccessToken getSnsAccessToken(){

        return SNS_ACCESS_TOKEN_CONTEXT.get();
    }
    /**
     * 清理上下文中的授权信息
     * */
    public static void clear(){

        SNS_ACCESS_TOKEN_CONTEXT.remove();
    }

}
