package com.zzwtec.wechat.common.enums;

public enum CallType {

    DOORBELL(1, "门口机"),
    ENCLOSURE(2, "围墙机"),
    ADMDEVICE(3, "中心机"),
    CELL(4, "房间"),
    PHONE(5, "业主手机"),
    ;

    private int type;
    private String name;

    CallType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static CallType findType(int callType) {
        CallType[] values = CallType.values();
        for (CallType value : values) {
            if (value.getType() == callType) {
                return value;
            }
        }
        return null;
    }
}
