package com.zzwtec.wechat.common;

import com.alibaba.fastjson.JSONObject;
import com.zzwtec.wechat.config.WeChatConfig;
import com.zzwtec.wechat.sdk.api.ApiResult;
import com.zzwtec.wechat.sdk.api.MenuApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/**
 * 自动初始化微信菜单
 * @author ShangJia
 * @date 2018/12/18
 */
@Component
public class InitMenuRunner implements ApplicationRunner {
    private Logger logger = LoggerFactory.getLogger(InitMenuRunner.class);
    @Autowired
    private WeChatConfig weChatConfig;
    @Override
    public void run(ApplicationArguments applicationArguments) throws Exception {
        String host=weChatConfig.getHost();
        //菜单模版json
        String templateJson = "{\n" +
                "        \"button\": [\n" +
                "            {\n" +
                "                \"type\": \"click\", \n" +
                "                \"name\": \"开门\", \n" +
                "                \"key\": \"door\", \n" +
                "                \"sub_button\": [ ]\n" +
                "            }, \n" +
                "            {\n" +
                "               \"type\": \"view\", \n" +
                "                        \"name\": \"个人中心\", \n" +
                "                        \"url\": \""+host+"/info/wechatOauth2\",\n" +
                "                        \"sub_button\": [ ]\n" +
                "            }, \n" +
                "            {\n" +
                "                \"type\": \"click\", \n" +
                "                \"name\": \"公告\", \n" +
                "                \"key\": \"msg\", \n" +
                "                \"sub_button\": [ ]\n" +
                "     \n" +
                "            }\n" +
                "        ]\n" +
                "}";
        logger.info("----------wechat----------");
        logger.info("check menu...");
        //正在使用的菜单json
        String usedJson = MenuApi.getMenu().getJson();
        JSONObject usedJsonObject = JSONObject.parseObject(usedJson);
        JSONObject templateJsonObject = JSONObject.parseObject(templateJson);
        if(templateJsonObject.equals(usedJsonObject.getJSONObject("menu"))){
            logger.info("menu is already up to date");
            logger.info("----------wechat----------");
            return;
        }
        logger.info("update menu...");
        ApiResult apiResult = MenuApi.createMenu(templateJson);
        JSONObject jsonObject = JSONObject.parseObject(apiResult.getJson());
        if(jsonObject.getString("errcode").equals("0")) {
            logger.info("template-menu update success");
        }
        else {
            logger.error("template-menu update fail, message : " + apiResult.getJson());
        }
        logger.info("----------wechat----------");
    }
}
