package com.zzwtec.wechat.common;

import org.beetl.ext.jfinal3.JFinal3BeetlRenderFactory;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.config.Constants;
import com.jfinal.core.Controller;
import com.jfinal.core.JFinal;
import com.jfinal.render.Render;
import com.jfinal.render.RenderManager;

/**
 * @ClassName BeetlRenderInterceptor
 * @Author Administrator
 * @Date 2018/12/11 0011 18:33
 */
public class BeetlRenderInterceptor implements Interceptor {

    private static final JFinal3BeetlRenderFactory rf = new JFinal3BeetlRenderFactory();
    private static final Constants constants = JFinal.me().getConstants();
    private static final RenderManager renderManager = RenderManager.me();

    public BeetlRenderInterceptor() {
        rf.config();
        System.out.println("beetl拦截器");
    }

    @Override
    public void intercept(Invocation inv) {
        inv.invoke();
        Render render = inv.getController().getRender();
        Controller ctr = inv.getController();
        if(render == null){
            String view = inv.getMethodName()+constants.getViewExtension();
            Render BeetlRender = rf.getRender(view);
            ctr.render(BeetlRender);
        }else{
            String view = render.getView();
            Render defaultRender = renderManager.getRenderFactory().getRender(view);
            //render 是否是默认  注意 有待改进
            boolean flag = defaultRender.getClass().isAssignableFrom(render.getClass());
            if(flag) {
                //替换
                Render beetlRender = rf.getRender(view);
                ctr.render(beetlRender);
            }
        }
    }
}