package com.zzwtec.third.utils.encryption;

import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ErrorCode;
import org.springframework.util.Assert;

/**
 * create by Jomchen on 2018/12/4
 */
public class ThirdEncodeStrategy {

    public static String encryptionCode(String str) throws BizException {
        Assert.notNull(str, "str is null");
        if (str.length() == 32) {
            return EncoderHandler.MD5(str);
        } else if (str.length() == 40) {
            return EncoderHandler.SHA1(str);
        } else if (str.length() == 128) {
            return EncoderHandler.SHA512(str);
        } else {
            throw new BizException(ErrorCode.ERROR_1.getCode(), "no encryption policy");
        }
    }

}
