package com.zzwtec.third.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * create by Jomchen on 2018/11/29
 */
public class StringUtil {
    /**
     * 判断参数有空为true,否则为false
     * @param strs
     * @return
     */
    public static boolean hasEmpty(String... strs){
        for(String str : strs) {
            if(isEmpty(str)) {
                return true;
            }
        }
        return false;
    }
    /**
     * 判断字符串对象是否为nul或空串
     * @return
     */
    public static boolean isEmpty(String str){
        if(str == null || "".equals(str.trim())){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 判断字符串是否不为空
     */
    public static boolean notEmpty(String str){
        return !isEmpty(str);
    }

    /**
     * 判断对象是否不为空
     */
    public static boolean isEmpty(Object str){
        if(str instanceof String){
            return isEmpty((String)str);
        }else{
            return isEmpty(String.valueOf(str));
        }
    }

    /**
     * 判断对象是否不为空
     */
    public static boolean notEmpty(Object str){
        return !isEmpty(str);
    }



    /**
     * List<String>转,分隔的字符串
     * @return
     */
    public static String join(List<String> list, String seperator){
        if(ListUtil.notEmpty(list)){
            StringBuffer sb = new StringBuffer();
            for(int i=0; i<list.size(); i++){
                if(i > 0) {
                    sb.append(seperator);
                }
                sb.append(list.get(i));
            }
            return sb.toString();
        }
        return "";
    }


    /**
     * 二分查找普通实现。
     * @param srcArray 有序数组 小到大
     * @param key 查找元素
     * @return  不存在返回-1
     */
    public static int binSearch(String[] srcArray, String key) {
        if(srcArray==null || srcArray.length==0) {
            return -1;
        }
        if(srcArray.length==1) {
            if(key.equals(srcArray[0])){
                return 0;
            }
            return -1;
        }
        int mid;
        int start = 0;
        int end = srcArray.length - 1;
        while (start <= end) {
            mid = (end - start) / 2 + start;
            int r = key.compareTo(srcArray[mid]);
            if (r < 0) {
                end = mid - 1;
            } else if (r > 0) {
                start = mid + 1;
            } else {
                return mid;
            }
        }
        return -1;
    }

    /**
     * 排序 小到大
     * @param srcArray
     */
    public static void sortArray(String[] srcArray){
        if(srcArray==null || srcArray.length<2)return;
        for(int i=0; i<srcArray.length-1; i++){
            for(int j=i+1; j<srcArray.length; j++){
                if(srcArray[i].compareTo(srcArray[j])>0){
                    String temp = srcArray[i];
                    srcArray[i] = srcArray[j];
                    srcArray[j] = temp;
                }
            }
        }
    }


    /**
     * 将字符串去掉所有的换行和回车和空格（主要用于用户身份证处理）
     * @param str
     * @return
     */
    public static String replaceBlank(String str){
        String dest = str;
        if (notEmpty(str)) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }
}
