package com.zzwtec.third.utils;

import com.zzwtec.third.common.RequestIdContext;

/**
 * create by Jomchen on 2018/11/30
 */
public class RequestObject<T> {

    private String requestId;

    private T data;

    public RequestObject(String requestId, T data) {
        this.requestId = requestId;
        this.data = data;
    }

    @SuppressWarnings("unchecked")
    public static<T> RequestObject build(T data) {
        String requestId = RequestIdContext.getRequestId();
        RequestObject request = new RequestObject(requestId, data);
        return request;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

}
