package com.zzwtec.third.utils;

import java.util.EnumSet;

/**
 * create by Jomchen on 2018/12/3
 */
public enum ErrorCode {

    ERROR_A_NEGATIVE(-1, "远程请求失败"),
    ERROR_0(0,"操作成功"),
    ERROR_1(1,"操作失败"),

    ERROR_2(2,"{0}参数为空指针"),
    ERROR_3(3,"{0}参数为空"),
    ERROR_4(4,"{0}参数非整型"),
    ERROR_5(5,"{0}参数格式错误"),
    ERROR_6(6,"rpc调用失败"),
    ERROR_7(7,"{0}参数范围错误"),
    ERROR_8(8,"不能解析签名"),
    ERROR_9(9,"appid不存在"),
    ERROR_10(10,"签名验证错误"),
    ERROR_11(11,"加密或解密错误"),
    ERROR_12(12,"请求超时"),
    ERROR_13(13,"没有获取到id"),
    ERROR_14(14,"没有相应的信息"),
    ERROR_15(15,"该访客不存在或该访客现拍照片已超时(1小时)"),
    ERROR_16(16,"该访客未录入现拍照片"),
    ERROR_17(17,"下载现拍图片失败"),
    ERROR_201(201,"操作已完成"),
    ERROR_300(300,"密码有误"),
    ERROR_301(301,"密码有误或没有该用户"),
    ERROR_302(302,"信息有误"),
    ERROR_303(303,"原密码有误"),
    ERROR_304(304,"该用户已存在"),
    ERROR_305(305,"该公告信息已经发布，不能修改"),
    ERROR_306(306,"该用户需短信验证"),
    ERROR_307(307,"业主信息与物管登记信息不一致！"),
    ERROR_308(308,"token已过时，请重新登录！"),
    ERROR_309(309,"版本过旧请升级！"),
    ERROR_310(310,"没有该用户"),
    ERROR_311(311,"没有Session"),
    ERROR_312(312,"验证码错误"),
    ERROR_313(313,"验证码失效 请重新获取"),
    ERROR_314(314,"该房间已有业主"),
    ERROR_315(315,"手机号码已存在"),
    ERROR_316(316,"含有非法字符，请重新输入"),
    ERROR_317(317,"该有线MAC地址设备已存在"),
    ERROR_318(318,"该无线MAC地址设备已存在"),
    ERROR_319(319,"数据不正确或数据不完整"),
    ERROR_320(320,"该树节点有数据不能删除"),
    ERROR_321(321,"老密码不正确，无法修改成新密码"),
    ERROR_322(322,"设置密码失败，没有对应的用户ID"),
    ERROR_323(323,"当前业务流程已经存在{0}"),
    ERROR_324(324,"当前业务流程不存在{0}"),
    ERROR_325(325,"当前业务流程已经结束{0}"),
    ERROR_326(326,"审核人员不同意，当前业务流程已经结束"),
    ERROR_327(327,"没有发现审核信息"),
    ERROR_328(328,"无有效数据或导入数据量超过限制"),
    ERROR_329(329,"上传数据过多"),
    ERROR_405(405,"该小区查询不到楼栋"),
    ERROR_406(406,"没有该设备"),
    ERROR_407(407,"没有该楼栋"),
    ERROR_408(408,"没有该房间"),
    ERROR_409(409,"该门牌已存在"),
    ERROR_410(410,"你不是户主"),
    ERROR_411(411,"操作太频繁，请稍后再试"),
    ERROR_412(412,"你账号已在其他客户端登录，如非本人操作，请修改登录密码"),
    ERROR_413(413,"没有该小区管理商"),
    ERROR_414(414,"没有该小区"),
    ERROR_415(415,"请求信息不合法"),
    ERROR_416(416,"ticket失效"),
    ERROR_417(417,"该手机未绑定房产，请到物业绑定"),
    ERROR_418(418,"查询不到门"),
    ERROR_419(419,"查询不到对象关系"),
    ERROR_420(420,"查询不到微信绑定关系"),
    ERROR_421(421,"{0}呼叫路线错误"),
    ERROR_422(422,"呼叫双方不在一个{0}"),
    ERROR_423(423,"微信绑定关系已存在"),
    ERROR_424(424,"对象树关系不正确"),
    ERROR_425(425,"该门编号已存在"),
    ERROR_426(426,"微信appid不存在"),
    ERROR_427(427,"该中心机编号已存在"),
    ERROR_428(428,"该门上已存在设备"),
    ERROR_429(429,"上传人脸数据失败"),
    ERROR_430(430,"没有检测出人脸数据"),
    ERROR_431(431,"查询不到安居宝摄像头绑定信息"),
    ERROR_432(432,"查询不到绿漫用户信息"),
    ERROR_433(433,"绿漫接口调用失败"),
    ERROR_434(434,"已添加该成员"),
    ERROR_435(435,"提取人脸特征信息失败"),
    ERROR_436(436,"该用户未上传人脸信息"),
    ERROR_437(437,"没有人脸特征模型文件"),
    ERROR_438(438,"查询不到开门日志记录或开门日志记录数据不完整"),
    ERROR_439(439,"查询不到小区编号"),
    ERROR_440(440,"查询不到开门图片"),
    ERROR_500(500,"权限不足"),
    ERROR_501(501,"没有该管理员"),
    ERROR_502(502,"密码有误或没有该管理员"),
    ERROR_503(503,"该功能在该平台已被禁止，请在网页端操作"),
    ERROR_504(504,"操作异常"),
    ERROR_505(505,"操作失败"),
    ERROR_506(506,"服务断路"),
    ERROR_601(601,"播放时长为空"),
    ERROR_701(701,"操作日志信息不全"),
    ERROR_702(702,"没有对应的操作码"),
    ERROR_703(703,"身份证格式不正确"),
    ERROR_704(704,"上传人脸失败"),
    ERROR_705(705,"人脸头像特征url为空"),
    ERROR_706(706,"用户base64编码图像为空"),
    ERROR_707(707,"虹软提取人脸画布失败"),
    ERROR_708(708,"用户不存在"),
    ERROR_709(709,"保存人脸头像原图失败，请重传!"),
    ERROR_710(710,"保存人脸头像虹软失败，请重传!"),
    ERROR_711(711,"获取face++ facetoken失败，请重传图片!"),
    ERROR_712(712,"用户未实名认证"),
    ERROR_801(801,"设备未配置慧联信息"),
    ERROR_802(802,"该手机号码已通过验证，不能获取语音验证码"),
    ERROR_803(803,"同一个手机号码24小时内最多只能获取3次,已达上限"),
    ERROR_804(804,"超过5分钟后才能再获取语音验证码"),
    ERROR_900(900,"该用户没有管理任何小区"),
    ERROR_901(901,"上传的所有小区都不在权限内"),
    ERROR_902(902,"该车场通道已存在"),
    ERROR_903(903,"不存在该车场通道"),
    ERROR_904(904,"该车场未关联商户"),
    ERROR_905(905,"该车场已存在该车辆类型"),
    ERROR_906(906,"该车场不存在该车辆类型"),
    ERROR_907(907,"该车场已存在该车牌类型"),
    ERROR_908(908,"该车场不存在该车牌类型"),
    ERROR_909(909,"未认证或认证信息已失效，请重新认证"),
    ERROR_910(910,"上传成功"),
    ERROR_911(911,"上传失败"),

    ;

    private int code;
    private String message;

    ErrorCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }
    public String getMessage() {
        return message;
    }

    /**
     * 通过编码获取错误枚举
     * @param code 错误码
     */
    public static ErrorCode getErrorCodeByCode(int code) {
        EnumSet<ErrorCode> enumSet = EnumSet.allOf(ErrorCode.class);
        for (ErrorCode e : enumSet) {
            if (e.getCode() == code) {
                return e;
            }
        }

        return null;
    }

    /**
     * 通过编码获取错误枚举
     * @param codeTemp 错误码
     */
    public static ErrorCode getErrorCodeByCode(String codeTemp) {
        int code = Integer.parseInt(codeTemp);
        EnumSet<ErrorCode> enumSet = EnumSet.allOf(ErrorCode.class);
        for (ErrorCode e : enumSet) {
            if (e.getCode() == code) {
                return e;
            }
        }

        return null;
    }

}
