package com.zzwtec.third.utils;

/**
 * create by Jomchen on 2018/11/29
 */
public class CharUtil {
    /**
     * 呼叫号码 正则表达式
     */
    public static final String CALLNUMBER_MATCH = "(^\\d{3,4}-?\\d{5,8}$)|(^(\\d{2})?1[3|4|5|6|7|8|9]\\d{9}$)";
    /**
     * 移动号码 正则表达式
     */
    public static final String MOBILECELLNUMBER_MATCH = "^((\\d{2})?1[3|4|5|6|7|8|9]\\d{9})|(780\\d{8})|(\\d{3}\\*{4}\\d{4})$";
    /**
     * 时间yyyy-MM-dd HH:mm:ss格式 正则表达式
     */
    public static final String TIME_LSDF_MATCH = "[0-9]{4}\\-[0-9]{2}\\-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}";
    /**
     * 时间戳 正则表达式
     */
    public static final String TIME_NOWTIMEDF_MATCH = "[0-9]{14}";
    /**
     * UTF8 正则表达式
     */
    public static final String UTF8_MATCH = "^([\\x09\\x0A\\x0D\\x20-\\x7E]|[\u4e00-\u9fa5]|[\uff0c\u3002\u3001\uff1b\u2019\u2018\u3010\u3011\u3001\uff1a\u201c\u201d\u300a\u300b\uff1f\uff01\u00b7\uffe5\u2026\uff08\uff09\u2014])+$";
    /**
     * MAC地址 正则表达式
     */
    public static final String MAC_MATCH="^([0-9]|[a-f]|[A-F]){2}(:([0-9]|[a-f]|[A-F]){2}){5}$";

    // 门牌号 正则表达式
    public static final String DOOR_NUM_MATCH = "^([0-9]){4}$";

    // 绿漫userId 格式:用户 ID|园区 ID 正则表达式
    public static final String LM_USERID_MATCH = "^[\\w\\-]+\\|[\\w\\-]+$";

    // 移动号码 正则表达式
    public static final String MOBILE_PHONE_MATCH = MOBILECELLNUMBER_MATCH;

    /**
     * 将二进制转换成16进制
     *
     * @param buf
     * @return
     */
    public static String parseByte2HexStr(byte buf[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * 将16进制转换为二进制
     *
     * @param hexStr
     * @return
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1)
            return null;
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2),
                    16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

    /**
     * 字符检测 是否含有非法字符
     * @param string 字符
     * @param rex 正则表达式
     * @return true没有非法字符 false含有非法字符
     */
    public static boolean characterDetection(String string, String rex){
        if(string==null){
            return false;
        }
        return string.matches(rex);
    }
}
