package com.zzwtec.third.utils;

/**
 * create by Jomchen on 2018/12/3
 */
public class BizException extends Exception {

    private int code;
    private String message;
    private Throwable throwable;

    public BizException(String code, String message) {
        this.code = Integer.parseInt(code);
        this.message = message;
    }

    public BizException(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public BizException(int code, String message, Throwable throwable) {
        this.code = code;
        this.message = message;
        this.throwable = throwable;
    }

    public BizException(ErrorCode errorCode) {
        this.code = errorCode.getCode();
        this.message = errorCode.getMessage();
    }

    public BizException(ErrorCode errorCode, Throwable throwable) {
        this.code = errorCode.getCode();
        this.message = errorCode.getMessage();
        this.throwable = throwable;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
