package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.basedata.dto.DeleteUserODTO;
import com.zzwtec.third.model.basedata.dto.UserCellDTO;
import com.zzwtec.third.model.basedata.dto.UserDTO;
import com.zzwtec.third.model.basedata.dto.UserODTO;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author ShangJia
 * @date 2018/12/10
 */
@Service
public class UserCellServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    public UserCellDTO[] queryUserCell(UserCellDTO userCellDTO) throws BizException {
        UserCellDTO[] result = restfulService.postOpenApi(
                openApiUrl.getUserCellQueryUserCellByCellId(),
                userCellDTO,
                new TypeReference<ResultObject<UserCellDTO[]>>(){}
        );
        return result;
    }

    public void deleteUserCellByUserIdCellId(DeleteUserODTO deleteUserODTO) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getUserDeleteUserCellByUserIdCellId(),
                deleteUserODTO,
                new TypeReference<ResultObject<Void>>(){}
        );
    }

    public UserDTO queryUserByUserId(String userId) throws BizException {
        UserDTO result = restfulService.postOpenApi(
                openApiUrl.getUserQueryUserByUserId(),
                userId,
                new TypeReference<ResultObject<UserDTO>>(){}
        );
        return result;
    }
    public String addUserByUserCellInfo(UserODTO userODTO) throws BizException {
        String result = restfulService.postOpenApi(
                openApiUrl.getUserAddUserByUserCell(),
                userODTO,
                new TypeReference<ResultObject<String>>(){}
        );
        return result;
    }

    public void updateUserByUserCellInfo(UserODTO userODTO) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getUserUpdUserByUserCell(),
                userODTO,
                new TypeReference<ResultObject<String>>(){}
        );
    }
}
