package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.common.Page;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.information.dto.NoticeDTO;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * create by Jomchen on 2018/12/7
 */
@Service
@Transactional
public class NoticeServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    public Page<NoticeDTO> queryNoticeByCommunityId(NoticeDTO noticeDTO) throws BizException {
        return restfulService.postOpenApi(
                openApiUrl.getNewsQueryNoticeByCommunityId(),
                noticeDTO,
                new TypeReference<ResultObject<Page<NoticeDTO>>>() {}
        );
    }

    public NoticeDTO queryNoticeByNoticeId(String id) throws BizException {
        return restfulService.postOpenApi(
                openApiUrl.getNewsQueryNoticeByNoticeId(),
                id,
                new TypeReference<ResultObject<NoticeDTO>>() {}
        );
    }

}
