package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.SysuserCache;
import com.zzwtec.third.model.permission.dto.LoginDTO;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * create by Jomchen on 2018/12/4
 */
@Service
@Transactional
public class LoginServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    public SysuserCache login(LoginDTO loginDTO) throws BizException {
        SysuserCache reslt = restfulService.postOpenApi(
                openApiUrl.getLoginUrl(),
                loginDTO,
                new TypeReference<ResultObject<SysuserCache>>() {}
        );

        return reslt;
    }

    public void loginOut(String tokenId) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getLoginOutUrl(),
                tokenId,
                new TypeReference<ResultObject<Void>>() {}
        );
    }

}
