package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.common.Page;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.basedata.dto.DoorDTO;
import com.zzwtec.third.model.basedata.dto.DoorRemoteDTO;
import com.zzwtec.third.model.basedata.dto.QueryDoor2DTO;
import com.zzwtec.third.model.basedata.dto.QueryDoorODTO;
import com.zzwtec.third.model.basedata.model.Door;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class DoorServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    /**
     * 根据楼栋id或小区id分页获取门信息
     * 如果buildId为空，就是获取该小区的所有门(楼栋门和小区门)
     * 如果buildId不为空，就是获取该楼栋的楼栋门
     *
     * @param requestPage 将小区id与楼栋id封装到page.data的0索引中，两个值不能同时为null
     * @author wxy
     */
    public Page<DoorDTO> queryPageDoorByCommunityIdOrBuildId(Page<DoorDTO> requestPage) throws BizException {
        Page<DoorDTO> doorDTOPage = restfulService.postOpenApi(
                openApiUrl.getQueryPageDoorUrl(),
                requestPage,
                new TypeReference<ResultObject<Page<DoorDTO>>>() {
                }
        );
        return doorDTOPage;
    }

    /**
     * 根据门id获取门信息
     *
     * @param queryDoor2DTO token、id不能为null
     * @author wxy
     */
    public DoorDTO queryDoorById(QueryDoor2DTO queryDoor2DTO) throws BizException {
        DoorDTO doorDTO = restfulService.postOpenApi(
                openApiUrl.getQueryDoorUrl(),
                queryDoor2DTO,
                new TypeReference<ResultObject<DoorDTO>>() {
                }
        );
        return doorDTO;
    }

    /**
     * 修改门的remote
     *
     * @param doorRemoteDTO
     * @return 
     * @author wxy
     */
    public void updateDoorRemote(DoorRemoteDTO doorRemoteDTO) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getUpdDoorRemoteUrl(),
                doorRemoteDTO,
                new TypeReference<ResultObject<Void>>() {
                }
        );
    }
}
