package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.basedata.dto.CommunityDTO;
import com.zzwtec.third.model.basedata.dto.QueryCommunityDTO;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 小区信息
 */
@Service
@Transactional
public class CommunityServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    public CommunityDTO queryCommunityInfo(QueryCommunityDTO queryCommunityDTO) throws BizException {
        CommunityDTO reslt = restfulService.postOpenApi(
                openApiUrl.getCommunityQueryCommunityInfoUrl(),
                queryCommunityDTO,
                new TypeReference<ResultObject<CommunityDTO>>() {}
        );

        return reslt;
    }

}
