package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.basedata.dto.CommunityConfigDTO;
import com.zzwtec.third.model.basedata.dto.CommunityDTO;
import com.zzwtec.third.model.basedata.dto.QueryCommunityDTO;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 小区配置
 */
@Service
@Transactional
public class CommunityConfigServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    public CommunityConfigDTO queryCommunityConfigByCommunityId(String communtiyId) throws BizException {
        CommunityConfigDTO reslt = restfulService.postOpenApi(
                openApiUrl.getCommunityQueryCommunityConfigByCommunityIdUrl(),
                communtiyId,
                new TypeReference<ResultObject<CommunityConfigDTO>>() {}
        );

        return reslt;
    }

}
