package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.common.Page;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.basedata.dto.CellDTO;
import com.zzwtec.third.model.basedata.dto.CellODTO;
import com.zzwtec.third.model.basedata.dto.DeleteCellODTO;
import com.zzwtec.third.model.basedata.dto.QueryCellODTO;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author ShangJia
 * @date 2018/12/6
 */
@Service
@Transactional
public class CellServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    /**
     * 根据小区id查询所有楼栋id
     * @param communityId
     * @return
     * @throws BizException
     */
    public String queryAllBuildIdByCommunityId(String communityId) throws BizException {
        String result = restfulService.postOpenApi(
                openApiUrl.getBuildGetAllBuild(),
                communityId,
                new TypeReference<ResultObject<String>>(){}
        );
        return result;
    }

    /**
     * 根据一个楼栋id查询下属房间
     * @param queryCellODTO
     * @return
     * @throws BizException
     */
    public Page<CellDTO> queryCellByBuildId(QueryCellODTO queryCellODTO) throws BizException {
        Page<CellDTO> result = restfulService.postOpenApi(
                openApiUrl.getCellGetCellByBuild(),
                queryCellODTO,
                new TypeReference<ResultObject<Page<CellDTO>>>(){}
        );
        return result;
    }

    /**
     * 根据房间id查询房间
     * @param cellId
     * @return
     * @throws BizException
     */
    public CellDTO queryCellByCellId(String cellId) throws BizException {
        CellDTO result = restfulService.postOpenApi(
                openApiUrl.getCellGetCellByCellid(),
                cellId,
                new TypeReference<ResultObject<CellDTO>>(){}
        );
        return result;
    }
    public String addCell(CellODTO cellODTO) throws BizException {
        String cellId = restfulService.postOpenApi(
                openApiUrl.getCellAdd(),
                cellODTO,
                new TypeReference<ResultObject<String>>(){}
        );
        return cellId;
    }

    public void updateCell(CellODTO cellODTO) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getCellUpdate(),
                cellODTO,
                new TypeReference<ResultObject<Void>>(){}
        );
    }

    public void deleteCellByIds(DeleteCellODTO deleteCellODTO) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getCellDelete(),
                deleteCellODTO,
                new TypeReference<ResultObject<Void>>(){}
        );
    }
}
