package com.zzwtec.third.services;

import com.alibaba.fastjson.TypeReference;
import com.zzwtec.third.common.OpenApiUrl;
import com.zzwtec.third.common.Page;
import com.zzwtec.third.config.restful.RestfulService;
import com.zzwtec.third.model.basedata.dto.BuildDTO;
import com.zzwtec.third.model.basedata.dto.BuildODTO;
import com.zzwtec.third.model.basedata.dto.DeleteBuildODTO;
import com.zzwtec.third.model.basedata.dto.QueryBuildDTO;
import com.zzwtec.third.utils.BizException;
import com.zzwtec.third.utils.ResultObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 远程调用ZZW的open-api模块的Build接口
 *
 * @author 温欣悦
 * @date 2018/12/7
 */
@Service
public class BuildServiceImpl {

    @Autowired
    private OpenApiUrl openApiUrl;
    @Autowired
    private RestfulService restfulService;

    /**
     * 根据小区id获取分页楼栋信息
     *
     * @param queryBuildDTO token、communityId、page不能为空
     * @return
     * @author wxy
     */
    public Page<BuildDTO> queryBuildByCommunityId(QueryBuildDTO queryBuildDTO) throws BizException {
        Page<BuildDTO> buildDTOPage = restfulService.postOpenApi(
                openApiUrl.getQueryBuildPageUrl(),
                queryBuildDTO,
                new TypeReference<ResultObject<Page<BuildDTO>>>() {
                }
        );
        return buildDTOPage;
    }

    /**
     * 添加楼栋信息
     *
     * @param buildODTO token、communityId、buildId、name、num、address不能为空
     * @return 添加的楼栋id
     * @author wxy
     */
    public String addBuild(BuildODTO buildODTO) throws BizException {
        String buildId = restfulService.postOpenApi(
                openApiUrl.getAddBuildUrl(),
                buildODTO,
                new TypeReference<ResultObject<String>>() {
                }
        );
        return buildId;
    }

    /**
     * 根据楼栋id数组删除楼栋信息
     *
     * @param deleteBuildODTO token、communityId、buildIds不能为空
     * @author wxy
     */
    public void deleteBuildByIds(DeleteBuildODTO deleteBuildODTO) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getDelBuildUrl(),
                deleteBuildODTO,
                new TypeReference<ResultObject<Void>>() {
                }
        );
    }

    /**
     * 根据楼栋id获取楼栋信息
     *
     * @author wxy
     */
    public BuildDTO queryBuildById(String id) throws BizException {
        BuildDTO buildDTO = restfulService.postOpenApi(
                openApiUrl.getQueryBuildUrl(),
                id,
                new TypeReference<ResultObject<BuildDTO>>() {
                }
        );
        return buildDTO;
    }

    /**
     * 修改楼栋信息
     *
     * @param buildODTO buildODTO token、communityId、buildId、name、num、address不能为空
     * @author wxy
     */
    public void updateBuild(BuildODTO buildODTO) throws BizException {
        restfulService.postOpenApi(
                openApiUrl.getUpdBuildUrl(),
                buildODTO,
                new TypeReference<ResultObject<Void>>() {
                }
        );
    }
}
