package com.zzwtec.third.model.basedata.dto;

import com.zzwtec.third.model.UserCellType;
import com.zzwtec.third.utils.TimeUtil;

import java.util.Arrays;
import java.util.List;

/**
 * 用户与房间关系
 * @author 邓燎燕
 *
 */
public class UserCellDTO {

	/**
	 * 住户IDs
	 */
	private String[] userIds;
	/**
	 * 房间IDs
	 */
	private String[] cellIds;
	/**
	 * 住户ID
	 */
	private String userId;
	/**
	 * 房间ID
	 */
	private String cellId;
	/**
	 * 关系类型<br>
	 * 1是户主 2是成员 3是租客
	 */
	private UserCellType type;
	/**
	 * 是否删除标志
	 */
	private Boolean deletec;
	/**
	 * 说明
	 */
	private String remark;
	/**
	 * 创建时间
	 */
	private Long createTime;
	/**
	 * 更新时间
	 */
	private Long updateTime;
	/**
	 * 更新人脸时间戳，采用System.currentMillions()方法获取
	 */
	private Long faceSynTimestamp;
	/**
	 * 住户登录手机号码
	 */
	private String userPhone;
	/**
	 * 住户名称
	 */
	private String userName;

	private Long lastOpenTime = 19700101000000l;
	/* ---------------------------- 扩展字段 ---------------------------- */
	/**
	 * 住户是否认证
	 */
	private Boolean isCheckIdCard;
	private String communityId;
	private String communityName;
	private String buildId;
	private String buildName;
	private String cellName;
	private String typeName;
	private Boolean confirmZzw;		// 是否是智之屋
	private String sysUserId;		// 登录用户的 id
	private long localDateTime;
	private List<String> communityIdList;
	private String[] buildIds;

	//是否短信验证
	private Boolean isMsgCheck;

	// 上海智能安防小区拦截专用（用于封装添加的用户的Id）
	private String userDTOID;

	public Long getLastOpenTime() {
		return lastOpenTime;
	}

	public void setLastOpenTime(Long lastOpenTime) {
		this.lastOpenTime = lastOpenTime;
	}

	public void setLastOpenTime(String lastOpenTime) {
		this.lastOpenTime = TimeUtil.timeStr2Long(lastOpenTime);
	}

	public Long getFaceSynTimestamp() {
		return faceSynTimestamp;
	}

	public void setFaceSynTimestamp(Long faceSynTimestamp) {
		this.faceSynTimestamp = faceSynTimestamp;
	}

	@Override
	public String toString() {
		return "UserCellDTO{" +
				"userIds=" + Arrays.toString(userIds) +
				", cellIds=" + Arrays.toString(cellIds) +
				", userId='" + userId + '\'' +
				", cellId='" + cellId + '\'' +
				", type=" + type +
				", deletec=" + deletec +
				", remark='" + remark + '\'' +
				", createTime=" + createTime +
				", updateTime=" + updateTime +
				", faceSynTimestamp=" + faceSynTimestamp +
				", userPhone='" + userPhone + '\'' +
				", userName='" + userName + '\'' +
				", lastOpenTime=" + lastOpenTime +
				", isCheckIdCard=" + isCheckIdCard +
				", communityId='" + communityId + '\'' +
				", communityName='" + communityName + '\'' +
				", buildId='" + buildId + '\'' +
				", buildName='" + buildName + '\'' +
				", cellName='" + cellName + '\'' +
				", typeName='" + typeName + '\'' +
				", confirmZzw=" + confirmZzw +
				", sysUserId='" + sysUserId + '\'' +
				", localDateTime=" + localDateTime +
				", communityIdList=" + communityIdList +
				", buildIds=" + Arrays.toString(buildIds) +
				", isMsgCheck=" + isMsgCheck +
				'}';
	}

	public String getCommunityId() {
		return communityId;
	}

	public void setCommunityId(String communityId) {
		this.communityId = communityId;
	}

	public String getBuildId() {
		return buildId;
	}

	public void setBuildId(String buildId) {
		this.buildId = buildId;
	}

	public String getUserId(){
		return this.userId;
	}
	
	public void setUserId(String userId){
		this.userId = userId;
	}
	
	public String getCellId(){
		return this.cellId;
	}
	
	public void setCellId(String cellId){
		this.cellId = cellId;
	}
	
	public void setType(UserCellType type){
		this.type = type;
	}
	public void setType(int type){
		this.type = UserCellType.getUserCellType(type);
	}

	public UserCellType getType(){
		return this.type;
	}
	
	public void setType(String type){
		this.type = UserCellType.valueOf(type);
	}
	
	public Boolean isDeletec(){
		return this.deletec;
	}
	
	public String getRemark(){
		return this.remark;
	}
	
	public void setRemark(String remark){		 
		this.remark = remark;
	}
	
	public String[] getUserIds() {
		return userIds;
	}

	public void setUserIds(String[] userIds) {
		this.userIds = userIds;
	}

	public String[] getCellIds() {
		return cellIds;
	}

	public void setCellIds(String[] cellIds) {
		this.cellIds = cellIds;
	}

	public String getUserPhone() {
		return userPhone;
	}

	public void setUserPhone(String userPhone) {
		this.userPhone = userPhone;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getCellName() {
		return cellName;
	}

	public void setCellName(String cellName) {
		this.cellName = cellName;
	}

	public String getBuildName() {
		return buildName;
	}

	public void setBuildName(String buildName) {
		this.buildName = buildName;
	}

	public String getCommunityName() {
		return communityName;
	}

	public void setCommunityName(String communityName) {
		this.communityName = communityName;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Long createTime) {
		this.createTime = createTime;
	}

	public Long getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Long updateTime) {
		this.updateTime = updateTime;
	}

	public Boolean getDeletec() {
		return deletec;
	}

	public void setDeletec(Boolean deletec){
		this.deletec = deletec;
	}

	public Boolean getIsCheckIdCard() { return isCheckIdCard; }

	public void setCheckIdCard(Boolean checkIdCard) { isCheckIdCard = checkIdCard; }

	public String getSysUserId() {
		return sysUserId;
	}

	public void setSysUserId(String sysUserId) {
		this.sysUserId = sysUserId;
	}

	public Boolean getConfirmZzw() {
		return confirmZzw;
	}

	public void setConfirmZzw(Boolean confirmZzw) {
		this.confirmZzw = confirmZzw;
	}

	public String[] getBuildIds() {
		return buildIds;
	}

	public void setBuildIds(String[] buildIds) {
		this.buildIds = buildIds;
	}

	public long getLocalDateTime() {
		return localDateTime;
	}

	public void setLocalDateTime(long localDateTime) {
		this.localDateTime = localDateTime;
	}

	public List<String> getCommunityIdList() {
		return communityIdList;
	}

	public void setCommunityIdList(List<String> communityIdList) {
		this.communityIdList = communityIdList;
	}

	public Boolean getMsgCheck() {
		return isMsgCheck;
	}

	public void setMsgCheck(Boolean msgCheck) {
		isMsgCheck = msgCheck;
	}

	public String getUserDTOID() {
		return userDTOID;
	}

	public void setUserDTOID(String userDTOID) {
		this.userDTOID = userDTOID;
	}
}
